/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.svg;

import android.graphics.RectF;
import android.graphics.drawable.PictureDrawable;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import com.yandex.div.core.annotations.InternalApi;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/yandex/div/svg/SvgDecoder;", "", "useViewBoundsAsIntrinsicSize", "", "(Z)V", "decode", "Landroid/graphics/drawable/PictureDrawable;", "source", "Ljava/io/InputStream;", "div-svg_release"})
@InternalApi
public final class SvgDecoder {
    private final boolean useViewBoundsAsIntrinsicSize;

    public SvgDecoder(boolean useViewBoundsAsIntrinsicSize) {
        this.useViewBoundsAsIntrinsicSize = useViewBoundsAsIntrinsicSize;
    }

    public /* synthetic */ SvgDecoder(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @Nullable
    public final PictureDrawable decode(@NotNull InputStream source) {
        PictureDrawable pictureDrawable;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            SVG sVG = SVG.getFromInputStream((InputStream)source);
            Intrinsics.checkNotNullExpressionValue((Object)sVG, (String)"getFromInputStream(source)");
            SVG svg = sVG;
            float svgWidth = 0.0f;
            float svgHeight = 0.0f;
            RectF viewBox = svg.getDocumentViewBox();
            if (this.useViewBoundsAsIntrinsicSize && viewBox != null) {
                svgWidth = viewBox.width();
                svgHeight = viewBox.height();
            } else {
                svgWidth = svg.getDocumentWidth();
                svgHeight = svg.getDocumentHeight();
            }
            if (viewBox == null && svgWidth > 0.0f && svgHeight > 0.0f) {
                svg.setDocumentViewBox(0.0f, 0.0f, svgWidth, svgHeight);
            }
            pictureDrawable = new PictureDrawable(svg.renderToPicture());
        }
        catch (SVGParseException ex) {
            pictureDrawable = null;
        }
        return pictureDrawable;
    }

    public SvgDecoder() {
        this(false, 1, null);
    }
}

