/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.internal;

import androidx.annotation.NonNull;
import com.yandex.div.logging.Severity;

public class Log {
    private static volatile boolean sEnabled = false;
    private static volatile Severity sSeverity = Severity.VERBOSE;

    private Log() {
    }

    public static boolean isEnabled() {
        return sEnabled;
    }

    public static void setEnabled(Boolean enabled) {
        sEnabled = enabled;
    }

    public static Severity getSeverity() {
        return sSeverity;
    }

    public static void setSeverity(@NonNull Severity severity) {
        sSeverity = severity;
    }

    public static void v(@NonNull String tag, @NonNull String message) {
        if (Log.isAtLeast(Severity.VERBOSE)) {
            android.util.Log.v((String)tag, (String)message);
        }
    }

    public static void v(@NonNull String tag, @NonNull String message, @NonNull Throwable th) {
        if (Log.isAtLeast(Severity.VERBOSE)) {
            android.util.Log.v((String)tag, (String)message, (Throwable)th);
        }
    }

    public static void d(@NonNull String tag, @NonNull String message) {
        if (Log.isAtLeast(Severity.DEBUG)) {
            android.util.Log.d((String)tag, (String)message);
        }
    }

    public static void d(@NonNull String tag, @NonNull String message, @NonNull Throwable th) {
        if (Log.isAtLeast(Severity.DEBUG)) {
            android.util.Log.d((String)tag, (String)message, (Throwable)th);
        }
    }

    public static void w(@NonNull String tag, @NonNull String message) {
        if (Log.isAtLeast(Severity.WARNING)) {
            android.util.Log.w((String)tag, (String)message);
        }
    }

    public static void w(@NonNull String tag, @NonNull Throwable th) {
        if (Log.isAtLeast(Severity.WARNING)) {
            android.util.Log.w((String)tag, (Throwable)th);
        }
    }

    public static void w(@NonNull String tag, @NonNull String message, @NonNull Throwable th) {
        if (Log.isAtLeast(Severity.WARNING)) {
            android.util.Log.w((String)tag, (String)message, (Throwable)th);
        }
    }

    public static void i(@NonNull String tag, @NonNull String message) {
        if (Log.isAtLeast(Severity.INFO)) {
            android.util.Log.i((String)tag, (String)message);
        }
    }

    public static void i(@NonNull String tag, @NonNull String message, @NonNull Throwable th) {
        if (Log.isAtLeast(Severity.INFO)) {
            android.util.Log.i((String)tag, (String)message, (Throwable)th);
        }
    }

    public static void e(@NonNull String tag, @NonNull String message) {
        if (Log.isAtLeast(Severity.ERROR)) {
            android.util.Log.e((String)tag, (String)message);
        }
    }

    public static void e(@NonNull String tag, @NonNull String message, @NonNull Throwable th) {
        if (Log.isAtLeast(Severity.ERROR)) {
            android.util.Log.e((String)tag, (String)message, (Throwable)th);
        }
    }

    static boolean isAtLeast(Severity minLevel) {
        if (!Log.isEnabled()) {
            return false;
        }
        return sSeverity.isAtLeast(minLevel);
    }
}

