/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.internal.util;

import com.yandex.div.internal.Assert;
import com.yandex.div.internal.util.NamedRunnable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0014\u0010\u0010\u001a\u00020\u000e2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H$J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\u0012\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u000f\u001a\u00020\fJ \u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0016\"\u0004\b\u0000\u0010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019R\u0014\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/yandex/div/internal/util/SingleThreadExecutor;", "", "executor", "Ljava/util/concurrent/Executor;", "threadNameSuffix", "", "(Ljava/util/concurrent/Executor;Ljava/lang/String;)V", "currentWorker", "Lcom/yandex/div/internal/util/SingleThreadExecutor$Worker;", "monitor", "passedTasks", "", "Ljava/lang/Runnable;", "addTaskLocked", "", "task", "handleError", "e", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "post", "submit", "Ljava/util/concurrent/Future;", "T", "callable", "Ljava/util/concurrent/Callable;", "Worker", "utils_release"})
public abstract class SingleThreadExecutor {
    @NotNull
    private final Executor executor;
    @NotNull
    private final String threadNameSuffix;
    @NotNull
    private final Object monitor;
    @Nullable
    private Worker currentWorker;
    @Nullable
    private List<Runnable> passedTasks;

    public SingleThreadExecutor(@NotNull Executor executor, @NotNull String threadNameSuffix) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)threadNameSuffix, (String)"threadNameSuffix");
        this.executor = executor;
        this.threadNameSuffix = threadNameSuffix;
        this.monitor = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void post(@NotNull Runnable task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Worker newWorker = null;
        Object object = this.monitor;
        synchronized (object) {
            boolean bl = false;
            this.addTaskLocked(task);
            if (this.currentWorker == null) {
                this.currentWorker = newWorker = new Worker();
            }
            Unit unit = Unit.INSTANCE;
        }
        if (newWorker != null) {
            this.executor.execute(newWorker);
        }
    }

    private final void addTaskLocked(Runnable task) {
        if (this.passedTasks == null) {
            this.passedTasks = new ArrayList(2);
        }
        List<Runnable> list = this.passedTasks;
        if (list != null) {
            list.add(task);
        }
    }

    @NotNull
    public final Future<?> submit(@NotNull Runnable task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        this.post(future);
        return future;
    }

    @NotNull
    public final <T> Future<T> submit(@NotNull Callable<T> callable) {
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        FutureTask<T> future = new FutureTask<T>(callable);
        this.post(future);
        return future;
    }

    protected abstract void handleError(@NotNull RuntimeException var1);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/yandex/div/internal/util/SingleThreadExecutor$Worker;", "Lcom/yandex/div/internal/util/NamedRunnable;", "(Lcom/yandex/div/internal/util/SingleThreadExecutor;)V", "execute", "", "utils_release"})
    private final class Worker
    extends NamedRunnable {
        public Worker() {
            Intrinsics.checkNotNullParameter((Object)SingleThreadExecutor.this, (String)"this$0");
            super(SingleThreadExecutor.this.threadNameSuffix);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void execute() {
            Object object;
            List tasks = null;
            Object object2 = SingleThreadExecutor.this.monitor;
            SingleThreadExecutor singleThreadExecutor = SingleThreadExecutor.this;
            synchronized (object2) {
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)singleThreadExecutor.currentWorker, (Object)this) || singleThreadExecutor.passedTasks == null) {
                    Assert.fail((String)"We shouldn't create excessive workers");
                    return;
                }
                tasks = singleThreadExecutor.passedTasks;
                singleThreadExecutor.passedTasks = null;
                object = Unit.INSTANCE;
            }
            boolean isGoingOn = false;
            isGoingOn = true;
            while (isGoingOn) {
                SingleThreadExecutor singleThreadExecutor2;
                Object object3;
                boolean normalExecution = false;
                try {
                    List list = tasks;
                    if (list != null) {
                        void $this$forEach$iv;
                        object3 = list;
                        singleThreadExecutor2 = SingleThreadExecutor.this;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Runnable task = (Runnable)element$iv;
                            boolean bl = false;
                            try {
                                task.run();
                            }
                            catch (RuntimeException e) {
                                singleThreadExecutor2.handleError(e);
                            }
                        }
                    }
                    normalExecution = true;
                }
                catch (Throwable throwable) {
                    object3 = SingleThreadExecutor.this.monitor;
                    singleThreadExecutor2 = SingleThreadExecutor.this;
                    synchronized (object3) {
                        boolean bl = false;
                        singleThreadExecutor2.currentWorker = null;
                        isGoingOn = false;
                        Unit unit = Unit.INSTANCE;
                    }
                    throw throwable;
                }
                object = SingleThreadExecutor.this.monitor;
                object3 = SingleThreadExecutor.this;
                synchronized (object) {
                    boolean bl = false;
                    if (((SingleThreadExecutor)object3).passedTasks != null) {
                        tasks = ((SingleThreadExecutor)object3).passedTasks;
                        ((SingleThreadExecutor)object3).passedTasks = null;
                    } else {
                        ((SingleThreadExecutor)object3).currentWorker = null;
                        isGoingOn = false;
                    }
                    singleThreadExecutor2 = Unit.INSTANCE;
                }
            }
        }
    }
}

