/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.internal.util;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.yandex.div.core.annotations.InternalApi;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

@InternalApi
public class Clock {
    @NonNull
    private static Clock sDefault = new Clock();

    @Inject
    public Clock() {
    }

    @NonNull
    public static Clock get() {
        return sDefault;
    }

    @VisibleForTesting
    public static void setForTests(@Nullable Clock clock) {
        sDefault = clock != null ? clock : new Clock();
    }

    public long getCurrentUnixTimestamp() {
        return TimeUnit.MILLISECONDS.toSeconds(this.getCurrentTimeMs());
    }

    public long getCurrentTimeMs() {
        return System.currentTimeMillis();
    }

    public long getUptimeMillis() {
        return SystemClock.uptimeMillis();
    }

    public long getElapsedRealtimeMs() {
        return SystemClock.elapsedRealtime();
    }
}

