/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.div.internal.util;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.core.view.ViewCompat;
import androidx.viewpager.widget.ViewPager;
import com.yandex.div.core.annotations.InternalApi;

@InternalApi
public class NestedHorizontalScrollCompanion {
    private static final int DX_UNCONSUMED = 1;
    private final View mTarget;
    private boolean mCanDispatchNestedScroll;
    private final float mSlop;
    private float mDownX;
    private float mDownY;

    public NestedHorizontalScrollCompanion(@NonNull View target) {
        this(target, (float)NestedHorizontalScrollCompanion.getScaledTouchSlop(target));
    }

    @VisibleForTesting
    NestedHorizontalScrollCompanion(@NonNull View target, float slop) {
        this.mTarget = target;
        ViewCompat.setNestedScrollingEnabled((View)this.mTarget, (boolean)true);
        this.mSlop = slop;
    }

    public NestedHorizontalScrollCompanion(@NonNull ViewPager target) {
        this((View)target, (float)NestedHorizontalScrollCompanion.getScaledTouchSlop((View)target));
    }

    @VisibleForTesting
    NestedHorizontalScrollCompanion(@NonNull ViewPager target, float slop) {
        this((View)target, slop);
        target.addOnPageChangeListener((ViewPager.OnPageChangeListener)new NestedScrollPageChangeListener(target));
    }

    public void dispatchOnScrollChanged() {
        this.mCanDispatchNestedScroll = false;
    }

    public void dispatchOnOverScrolled(boolean clampedX) {
        if (this.mCanDispatchNestedScroll && clampedX) {
            ViewCompat.dispatchNestedScroll((View)this.mTarget, (int)0, (int)0, (int)1, (int)0, null);
        }
    }

    public void dispatchTouchEventAfterSuperCall(@NonNull MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mDownX = event.getX();
                this.mDownY = event.getY();
                break;
            }
            case 1: 
            case 3: {
                this.mCanDispatchNestedScroll = false;
                ViewCompat.stopNestedScroll((View)this.mTarget);
                break;
            }
            case 2: {
                float dx = Math.abs(event.getX() - this.mDownX);
                float dy = Math.abs(event.getY() - this.mDownY);
                if (this.mCanDispatchNestedScroll || !(dx >= this.mSlop) || !(dx > dy)) break;
                this.mCanDispatchNestedScroll = true;
                ViewCompat.startNestedScroll((View)this.mTarget, (int)1);
            }
        }
    }

    private static int getScaledTouchSlop(@NonNull View target) {
        return ViewConfiguration.get((Context)target.getContext()).getScaledTouchSlop();
    }

    private class NestedScrollPageChangeListener
    extends ViewPager.SimpleOnPageChangeListener {
        private final ViewPager mViewPager;
        private int mScrollState = -1;
        private float mPreviousPageOffset;

        private NestedScrollPageChangeListener(ViewPager viewPager) {
            this.mViewPager = viewPager;
        }

        public void onPageScrollStateChanged(int state) {
            this.mScrollState = state;
            if (this.mScrollState == 0) {
                this.mPreviousPageOffset = -1.0f;
            }
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            boolean isEdgePosition;
            boolean isLastPosition = position == this.mViewPager.getAdapter().getCount() - 1;
            boolean bl = isEdgePosition = position == 0 || isLastPosition;
            if (isEdgePosition && this.mScrollState == 1 && this.mPreviousPageOffset == 0.0f && positionOffset == 0.0f) {
                NestedHorizontalScrollCompanion.this.dispatchOnOverScrolled(true);
            }
            this.mPreviousPageOffset = positionOffset;
        }
    }
}

