/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.varioqub.protobuf.nano;

import com.yandex.varioqub.protobuf.nano.FieldData;

public final class FieldArray
implements Cloneable {
    private static final FieldData DELETED = new FieldData();
    private boolean mGarbage = false;
    private int[] mFieldNumbers;
    private FieldData[] mData;
    private int mSize;

    FieldArray() {
        this(10);
    }

    FieldArray(int n) {
        int n2 = this.idealIntArraySize(n);
        this.mFieldNumbers = new int[n2];
        this.mData = new FieldData[n2];
        this.mSize = 0;
    }

    private void gc() {
        FieldArray fieldArray = this;
        int n = fieldArray.mSize;
        int n2 = 0;
        int[] nArray = fieldArray.mFieldNumbers;
        FieldData[] fieldDataArray = fieldArray.mData;
        for (int i = 0; i < n; ++i) {
            FieldData fieldData = fieldDataArray[i];
            if (fieldData == DELETED) continue;
            if (i != n2) {
                nArray[n2] = nArray[i];
                fieldDataArray[n2] = fieldData;
                fieldDataArray[i] = null;
            }
            ++n2;
        }
        FieldArray fieldArray2 = this;
        fieldArray2.mGarbage = false;
        fieldArray2.mSize = n2;
    }

    private int idealIntArraySize(int n) {
        return this.idealByteArraySize(n * 4) / 4;
    }

    private int idealByteArraySize(int n) {
        for (int i = 4; i < 32; ++i) {
            int n2 = (1 << i) - 12;
            if (n > n2) continue;
            return n2;
        }
        return n;
    }

    private int binarySearch(int n) {
        int n2 = 0;
        int n3 = this.mSize - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            int n5 = this.mFieldNumbers[n4];
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return ~n2;
    }

    private boolean arrayEquals(int[] nArray, int[] nArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean arrayEquals(FieldData[] fieldDataArray, FieldData[] fieldDataArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (fieldDataArray[i].equals(fieldDataArray2[i])) continue;
            return false;
        }
        return true;
    }

    FieldData get(int n) {
        FieldData fieldData;
        int n2;
        if ((n2 = this.binarySearch(n2)) >= 0 && (fieldData = this.mData[n2]) != DELETED) {
            return fieldData;
        }
        return null;
    }

    void remove(int n) {
        if ((n = this.binarySearch(n)) >= 0) {
            FieldData[] fieldDataArray = this.mData;
            FieldData fieldData = DELETED;
            if (this.mData[n] != fieldData) {
                fieldDataArray[n] = fieldData;
                this.mGarbage = true;
            }
        }
    }

    void put(int n, FieldData fieldData) {
        int n2 = this.binarySearch(n);
        if (n2 >= 0) {
            this.mData[n2] = fieldData;
        } else {
            int n3;
            int n4;
            Object[] objectArray;
            int n5 = this.mSize;
            if ((n2 ^= 0xFFFFFFFF) < n5) {
                objectArray = this.mData;
                if (this.mData[n2] == DELETED) {
                    this.mFieldNumbers[n2] = n;
                    objectArray[n2] = fieldData;
                    return;
                }
            }
            if (this.mGarbage && n5 >= this.mFieldNumbers.length) {
                this.gc();
                n2 = ~this.binarySearch(n);
            }
            if ((n5 = this.mSize) >= this.mFieldNumbers.length) {
                int n6 = this.idealIntArraySize(n5 + 1);
                int[] nArray = new int[n6];
                objectArray = new FieldData[n6];
                n4 = this.mFieldNumbers.length;
                System.arraycopy(this.mFieldNumbers, 0, nArray, 0, n4);
                n4 = this.mData.length;
                System.arraycopy(this.mData, 0, objectArray, 0, n4);
                this.mFieldNumbers = nArray;
                this.mData = objectArray;
            }
            if ((n3 = this.mSize) - n2 != 0) {
                objectArray = this.mFieldNumbers;
                int n7 = n3;
                int n8 = n2;
                n3 = n8 + 1;
                n4 = n7 - n8;
                System.arraycopy(this.mFieldNumbers, n2, objectArray, n3, n4);
                objectArray = this.mData;
                n4 = this.mSize - n2;
                System.arraycopy(this.mData, n2, objectArray, n3, n4);
            }
            this.mFieldNumbers[n2] = n;
            this.mData[n2] = fieldData;
            ++this.mSize;
        }
    }

    int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    FieldData dataAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mData[n];
    }

    public boolean equals(Object fieldDataArray) {
        int n;
        if (fieldDataArray == this) {
            return true;
        }
        if (!(fieldDataArray instanceof FieldArray)) {
            return false;
        }
        fieldDataArray = (FieldArray)fieldDataArray;
        if (this.size() != fieldDataArray.size()) {
            return false;
        }
        int[] nArray = this.mFieldNumbers;
        int[] nArray2 = fieldDataArray.mFieldNumbers;
        int n2 = this.mSize;
        return this.arrayEquals(nArray, nArray2, n2) && super.arrayEquals(this, fieldDataArray = fieldDataArray.mData, n = this.mSize);
    }

    public int hashCode() {
        if (this.mGarbage) {
            this.gc();
        }
        int n = 17;
        for (int i = 0; i < this.mSize; ++i) {
            n = (n * 31 + this.mFieldNumbers[i]) * 31 + this.mData[i].hashCode();
        }
        return n;
    }

    public final FieldArray clone() {
        FieldArray fieldArray;
        FieldArray fieldArray2 = this;
        int n = fieldArray2.size();
        FieldArray fieldArray3 = fieldArray;
        fieldArray = new FieldArray(n);
        System.arraycopy(fieldArray2.mFieldNumbers, 0, fieldArray3.mFieldNumbers, 0, n);
        for (int i = 0; i < n; ++i) {
            FieldData fieldData = this.mData[i];
            if (fieldData == null) continue;
            fieldArray3.mData[i] = fieldData.clone();
        }
        fieldArray3.mSize = n;
        return fieldArray3;
    }
}

