/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table;

import com.yandex.ydb.core.Result;
import com.yandex.ydb.table.Session;
import com.yandex.ydb.table.impl.TableClientBuilderImpl;
import com.yandex.ydb.table.rpc.TableRpc;
import com.yandex.ydb.table.settings.CreateSessionSettings;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.WillClose;

public interface TableClient
extends AutoCloseable {
    public static Builder newClient(@WillClose TableRpc tableRpc) {
        return new TableClientBuilderImpl(tableRpc);
    }

    public CompletableFuture<Result<Session>> createSession(CreateSessionSettings var1);

    default public CompletableFuture<Result<Session>> createSession() {
        return this.createSession(new CreateSessionSettings());
    }

    public CompletableFuture<Result<Session>> getOrCreateSession();

    @Override
    public void close();

    public static interface Builder {
        public Builder queryCacheSize(int var1);

        public Builder keepQueryText(boolean var1);

        public Builder sessionPoolSize(int var1, int var2);

        public Builder sessionKeepAliveTime(long var1, TimeUnit var3);

        public Builder sessionMaxIdleTime(long var1, TimeUnit var3);

        public Builder sessionCreationMaxRetries(int var1);

        public TableClient build();
    }
}

