/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.core.Result;
import com.yandex.ydb.table.impl.SessionImpl;
import com.yandex.ydb.table.query.DataQuery;
import com.yandex.ydb.table.query.DataQueryResult;
import com.yandex.ydb.table.query.Params;
import com.yandex.ydb.table.settings.ExecuteDataQuerySettings;
import com.yandex.ydb.table.transaction.TxControl;
import com.yandex.ydb.table.types.Type;
import com.yandex.ydb.table.types.proto.ProtoType;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

final class DataQueryImpl
implements DataQuery {
    private final SessionImpl session;
    private final String queryId;
    private final ImmutableMap<String, Type> types;
    private final ImmutableMap<String, ValueProtos.Type> typesPb;
    @Nullable
    private final String text;
    private final String textHash;

    DataQueryImpl(SessionImpl session, String queryId, String text, boolean keepText, Map<String, ValueProtos.Type> parametersTypes) {
        this.session = session;
        this.queryId = queryId;
        this.types = DataQueryImpl.buildTypes(parametersTypes);
        this.typesPb = ImmutableMap.copyOf(parametersTypes);
        this.text = keepText ? text : null;
        this.textHash = DataQueryImpl.makeHash(text);
    }

    static String makeHash(String text) {
        return Hashing.sha256().hashString((CharSequence)text, StandardCharsets.UTF_8).toString();
    }

    private static ImmutableMap<String, Type> buildTypes(Map<String, ValueProtos.Type> parametersTypes) {
        ImmutableMap.Builder types = new ImmutableMap.Builder();
        for (Map.Entry<String, ValueProtos.Type> e : parametersTypes.entrySet()) {
            types.put((Object)e.getKey(), (Object)ProtoType.fromPb(e.getValue()));
        }
        return types.build();
    }

    @Override
    public String getId() {
        return this.queryId;
    }

    @Override
    public Params.KnownTypes newParams() {
        return Params.withKnownTypes(this.types, this.typesPb);
    }

    @Override
    public Optional<String> getText() {
        return Optional.ofNullable(this.text);
    }

    String getTextHash() {
        return this.textHash;
    }

    @Override
    public CompletableFuture<Result<DataQueryResult>> execute(TxControl txControl, Params params, ExecuteDataQuerySettings settings) {
        return this.session.executePreparedDataQuery(this.queryId, this.text, txControl, params, settings);
    }
}

