/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.impl;

import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.Status;
import com.yandex.ydb.core.StatusCode;
import com.yandex.ydb.core.rpc.OperationTray;
import com.yandex.ydb.table.Session;
import com.yandex.ydb.table.SessionStatus;
import com.yandex.ydb.table.YdbTable;
import com.yandex.ydb.table.description.TableColumn;
import com.yandex.ydb.table.description.TableDescription;
import com.yandex.ydb.table.impl.DataQueryImpl;
import com.yandex.ydb.table.impl.QueryCache;
import com.yandex.ydb.table.impl.SessionPool;
import com.yandex.ydb.table.impl.TransactionImpl;
import com.yandex.ydb.table.query.DataQuery;
import com.yandex.ydb.table.query.DataQueryResult;
import com.yandex.ydb.table.query.ExplainDataQueryResult;
import com.yandex.ydb.table.query.Params;
import com.yandex.ydb.table.rpc.TableRpc;
import com.yandex.ydb.table.settings.AlterTableSettings;
import com.yandex.ydb.table.settings.AutoPartitioningPolicy;
import com.yandex.ydb.table.settings.BeginTxSettings;
import com.yandex.ydb.table.settings.CloseSessionSettings;
import com.yandex.ydb.table.settings.CommitTxSettings;
import com.yandex.ydb.table.settings.CopyTableSettings;
import com.yandex.ydb.table.settings.CreateTableSettings;
import com.yandex.ydb.table.settings.DescribeTableSettings;
import com.yandex.ydb.table.settings.DropTableSettings;
import com.yandex.ydb.table.settings.ExecuteDataQuerySettings;
import com.yandex.ydb.table.settings.ExecuteSchemeQuerySettings;
import com.yandex.ydb.table.settings.ExplainDataQuerySettings;
import com.yandex.ydb.table.settings.KeepAliveSessionSettings;
import com.yandex.ydb.table.settings.PartitioningPolicy;
import com.yandex.ydb.table.settings.PrepareDataQuerySettings;
import com.yandex.ydb.table.settings.RollbackTxSettings;
import com.yandex.ydb.table.settings.StoragePolicy;
import com.yandex.ydb.table.transaction.Transaction;
import com.yandex.ydb.table.transaction.TransactionMode;
import com.yandex.ydb.table.transaction.TxControl;
import com.yandex.ydb.table.types.proto.ProtoType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

class SessionImpl
implements Session {
    private static final AtomicReferenceFieldUpdater<SessionImpl, State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(SessionImpl.class, State.class, "state");
    private final String id;
    private final TableRpc tableRpc;
    private final OperationTray operationTray;
    @Nullable
    private final SessionPool sessionPool;
    @Nullable
    private final QueryCache queryCache;
    private final boolean keepQueryText;
    private volatile State state = State.ACTIVE;

    SessionImpl(String id, TableRpc tableRpc, SessionPool sessionPool, int queryCacheSize, boolean keepQueryText) {
        this.id = id;
        this.tableRpc = tableRpc;
        this.operationTray = tableRpc.getOperationTray();
        this.sessionPool = sessionPool;
        this.queryCache = queryCacheSize > 0 ? new QueryCache(queryCacheSize) : null;
        this.keepQueryText = keepQueryText;
    }

    @Override
    public String getId() {
        return this.id;
    }

    State getState() {
        return stateUpdater.get(this);
    }

    boolean switchState(State from, State to) {
        return stateUpdater.compareAndSet(this, from, to);
    }

    @Override
    public CompletableFuture<Status> createTable(String path, TableDescription tableDescriptions, CreateTableSettings settings) {
        YdbTable.PartitioningPolicy.Builder policyProto;
        Object policy;
        YdbTable.CreateTableRequest.Builder request = YdbTable.CreateTableRequest.newBuilder().setSessionId(this.id).setPath(path).addAllPrimaryKey(tableDescriptions.getPrimaryKeys());
        for (TableColumn column : tableDescriptions.getColumns()) {
            request.addColumns(YdbTable.ColumnMeta.newBuilder().setName(column.getName()).setType(ProtoType.toPb(column.getType())).build());
        }
        if (settings.getPresetName() != null) {
            request.getProfileBuilder().setPresetName(settings.getPresetName());
        }
        if (settings.getExecutionPolicy() != null) {
            request.getProfileBuilder().getExecutionPolicyBuilder().setPresetName(settings.getExecutionPolicy());
        }
        if (settings.getCompactionPolicy() != null) {
            request.getProfileBuilder().getCompactionPolicyBuilder().setPresetName(settings.getExecutionPolicy());
        }
        if ((policy = settings.getPartitioningPolicy()) != null) {
            policyProto = request.getProfileBuilder().getPartitioningPolicyBuilder();
            if (((PartitioningPolicy)policy).getPresetName() != null) {
                policyProto.setPresetName(((PartitioningPolicy)policy).getPresetName());
            }
            if (((PartitioningPolicy)policy).getAutoPartitioning() != null) {
                policyProto.setAutoPartitioning(SessionImpl.toPb(((PartitioningPolicy)policy).getAutoPartitioning()));
            }
            if (((PartitioningPolicy)policy).getUniformPartitions() > 0L) {
                policyProto.setUniformPartitions(((PartitioningPolicy)policy).getUniformPartitions());
            }
        }
        if ((policy = settings.getStoragePolicy()) != null) {
            policyProto = request.getProfileBuilder().getStoragePolicyBuilder();
            if (((StoragePolicy)policy).getPresetName() != null) {
                policyProto.setPresetName(((StoragePolicy)policy).getPresetName());
            }
            if (((StoragePolicy)policy).getSysLog() != null) {
                policyProto.getSyslogBuilder().setStorageKind(((StoragePolicy)policy).getSysLog());
            }
            if (((StoragePolicy)policy).getLog() != null) {
                policyProto.getLogBuilder().setStorageKind(((StoragePolicy)policy).getLog());
            }
            if (((StoragePolicy)policy).getData() != null) {
                policyProto.getDataBuilder().setStorageKind(((StoragePolicy)policy).getData());
            }
            if (((StoragePolicy)policy).getExternal() != null) {
                policyProto.getExternalBuilder().setStorageKind(((StoragePolicy)policy).getExternal());
            }
        }
        return this.tableRpc.createTable(request.build()).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.CreateTableResponse)response.expect("createTable()")).getOperation());
        });
    }

    private static YdbTable.PartitioningPolicy.AutoPartitioningPolicy toPb(AutoPartitioningPolicy policy) {
        switch (policy) {
            case AUTO_SPLIT: {
                return YdbTable.PartitioningPolicy.AutoPartitioningPolicy.AUTO_SPLIT;
            }
            case AUTO_SPLIT_MERGE: {
                return YdbTable.PartitioningPolicy.AutoPartitioningPolicy.AUTO_SPLIT_MERGE;
            }
            case DISABLED: {
                return YdbTable.PartitioningPolicy.AutoPartitioningPolicy.DISABLED;
            }
        }
        throw new IllegalArgumentException("unknown AutoPartitioningPolicy: " + (Object)((Object)policy));
    }

    @Override
    public CompletableFuture<Status> dropTable(String path, DropTableSettings settings) {
        YdbTable.DropTableRequest request = YdbTable.DropTableRequest.newBuilder().setSessionId(this.id).setPath(path).build();
        return this.tableRpc.dropTable(request).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.DropTableResponse)response.expect("dropTable()")).getOperation());
        });
    }

    @Override
    public CompletableFuture<Status> alterTable(String path, AlterTableSettings settings) {
        YdbTable.AlterTableRequest.Builder builder = YdbTable.AlterTableRequest.newBuilder().setSessionId(this.id).setPath(path);
        settings.forEachAddColumn((name, type) -> builder.addAddColumns(YdbTable.ColumnMeta.newBuilder().setName(name).setType(ProtoType.toPb(type)).build()));
        settings.forEachDropColumn(arg_0 -> ((YdbTable.AlterTableRequest.Builder)builder).addDropColumns(arg_0));
        return this.tableRpc.alterTable(builder.build()).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.AlterTableResponse)response.expect("alterTable()")).getOperation());
        });
    }

    @Override
    public CompletableFuture<Status> copyTable(String src, String dst, CopyTableSettings settings) {
        YdbTable.CopyTableRequest request = YdbTable.CopyTableRequest.newBuilder().setSessionId(this.id).setSourcePath(src).setDestinationPath(dst).build();
        return this.tableRpc.copyTable(request).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.CopyTableResponse)response.expect("copyTable()")).getOperation());
        });
    }

    @Override
    public CompletableFuture<Result<TableDescription>> describeTable(String path, DescribeTableSettings settings) {
        YdbTable.DescribeTableRequest request = YdbTable.DescribeTableRequest.newBuilder().setSessionId(this.id).setPath(path).build();
        return this.tableRpc.describeTable(request).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.operationTray.waitResult(((YdbTable.DescribeTableResponse)response.expect("describeTable()")).getOperation(), YdbTable.DescribeTableResult.class, SessionImpl::mapDescribeTable);
        });
    }

    private static TableDescription mapDescribeTable(YdbTable.DescribeTableResult result) {
        TableDescription.Builder description = TableDescription.newBuilder();
        for (int i = 0; i < result.getColumnsCount(); ++i) {
            YdbTable.ColumnMeta column = result.getColumns(i);
            description.addNonnullColumn(column.getName(), ProtoType.fromPb(column.getType()));
        }
        description.setPrimaryKeys((List<String>)result.getPrimaryKeyList());
        return description.build();
    }

    private static YdbTable.TransactionSettings txSettings(TransactionMode transactionMode) {
        YdbTable.TransactionSettings.Builder settings = YdbTable.TransactionSettings.newBuilder();
        if (transactionMode == TransactionMode.SERIALIZABLE_READ_WRITE) {
            settings.setSerializableReadWrite(YdbTable.SerializableModeSettings.getDefaultInstance());
        } else if (transactionMode == TransactionMode.ONLINE_READ_ONLY) {
            settings.setOnlineReadOnly(YdbTable.OnlineModeSettings.getDefaultInstance());
        } else if (transactionMode == TransactionMode.STALE_READ_ONLY) {
            settings.setStaleReadOnly(YdbTable.StaleModeSettings.getDefaultInstance());
        }
        return settings.build();
    }

    @Override
    public CompletableFuture<Result<DataQueryResult>> executeDataQuery(String query, TxControl txControl, Params params, ExecuteDataQuerySettings settings) {
        DataQueryImpl dataQuery;
        if (this.queryCache != null && (dataQuery = this.queryCache.find(query)) != null) {
            return dataQuery.execute(txControl, params, settings).whenComplete((r, t) -> {
                if (r.getCode() == StatusCode.NOT_FOUND) {
                    this.queryCache.remove(dataQuery);
                }
            });
        }
        YdbTable.ExecuteDataQueryRequest.Builder request = YdbTable.ExecuteDataQueryRequest.newBuilder().setSessionId(this.id).setTxControl(txControl.toPb()).setQuery(YdbTable.Query.newBuilder().setYqlText(query)).putAllParameters(params.toPb());
        boolean keepInQueryCache = settings.isKeepInQueryCache();
        if (this.queryCache != null && keepInQueryCache) {
            request.getQueryCachePolicyBuilder().setKeepInCache(true);
        }
        return this.interceptResult((CompletableFuture)this.tableRpc.executeDataQuery(request.build()).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.operationTray.waitResult(((YdbTable.ExecuteDataQueryResponse)response.expect("executeDataQuery()")).getOperation(), YdbTable.ExecuteQueryResult.class, result -> this.mapExecuteDataQuery((YdbTable.ExecuteQueryResult)result, query, keepInQueryCache));
        }));
    }

    private DataQueryResult mapExecuteDataQuery(YdbTable.ExecuteQueryResult result, @Nullable String queryText, boolean keepInQueryCache) {
        if (keepInQueryCache && result.hasQueryMeta() && queryText != null) {
            assert (this.queryCache != null);
            String queryId = result.getQueryMeta().getId();
            Map types = result.getQueryMeta().getParametersTypesMap();
            this.queryCache.put(new DataQueryImpl(this, queryId, queryText, this.keepQueryText, types));
        }
        YdbTable.TransactionMeta txMeta = result.getTxMeta();
        return new DataQueryResult(txMeta.getId(), result.getResultSetsList());
    }

    CompletableFuture<Result<DataQueryResult>> executePreparedDataQuery(String queryId, @Nullable String queryText, TxControl txControl, Params params, ExecuteDataQuerySettings settings) {
        boolean keepInQueryCache;
        YdbTable.ExecuteDataQueryRequest.Builder request = YdbTable.ExecuteDataQueryRequest.newBuilder().setSessionId(this.id).setTxControl(txControl.toPb());
        request.getQueryBuilder().setId(queryId);
        request.putAllParameters(params.toPb());
        boolean bl = keepInQueryCache = this.queryCache != null && settings.isKeepInQueryCache();
        if (keepInQueryCache) {
            request.getQueryCachePolicyBuilder().setKeepInCache(true);
        }
        return this.interceptResult((CompletableFuture)this.tableRpc.executeDataQuery(request.build()).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.tableRpc.getOperationTray().waitResult(((YdbTable.ExecuteDataQueryResponse)response.expect("executeDataQuery()")).getOperation(), YdbTable.ExecuteQueryResult.class, result -> this.mapExecuteDataQuery((YdbTable.ExecuteQueryResult)result, queryText, keepInQueryCache));
        }));
    }

    @Override
    public CompletableFuture<Result<DataQuery>> prepareDataQuery(String query, PrepareDataQuerySettings settings) {
        YdbTable.PrepareDataQueryRequest.Builder request = YdbTable.PrepareDataQueryRequest.newBuilder().setSessionId(this.id).setYqlText(query);
        boolean keepInQueryCache = this.queryCache != null && settings.isKeepInQueryCache();
        return this.interceptResult((CompletableFuture)this.tableRpc.prepareDataQuery(request.build()).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.operationTray.waitResult(((YdbTable.PrepareDataQueryResponse)response.expect("prepareDataQuery()")).getOperation(), YdbTable.PrepareQueryResult.class, result -> {
                String queryId = result.getQueryId();
                Map types = result.getParametersTypesMap();
                DataQueryImpl dataQuery = new DataQueryImpl(this, queryId, query, this.keepQueryText, types);
                if (keepInQueryCache) {
                    this.queryCache.put(dataQuery);
                }
                return dataQuery;
            });
        }));
    }

    @Override
    public CompletableFuture<Status> executeSchemeQuery(String query, ExecuteSchemeQuerySettings settings) {
        YdbTable.ExecuteSchemeQueryRequest request = YdbTable.ExecuteSchemeQueryRequest.newBuilder().setSessionId(this.id).setYqlText(query).build();
        return this.interceptStatus((CompletableFuture<Status>)this.tableRpc.executeSchemeQuery(request).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.ExecuteSchemeQueryResponse)response.expect("executeSchemaQuery()")).getOperation());
        }));
    }

    @Override
    public CompletableFuture<Result<ExplainDataQueryResult>> explainDataQuery(String query, ExplainDataQuerySettings settings) {
        YdbTable.ExplainDataQueryRequest request = YdbTable.ExplainDataQueryRequest.newBuilder().setSessionId(this.id).setYqlText(query).build();
        return this.interceptResult((CompletableFuture)this.tableRpc.explainDataQuery(request).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.operationTray.waitResult(((YdbTable.ExplainDataQueryResponse)response.expect("explainDataQuery()")).getOperation(), YdbTable.ExplainQueryResult.class, result -> new ExplainDataQueryResult(result.getQueryAst(), result.getQueryPlan()));
        }));
    }

    @Override
    public CompletableFuture<Result<Transaction>> beginTransaction(TransactionMode transactionMode, BeginTxSettings settings) {
        YdbTable.BeginTransactionRequest request = YdbTable.BeginTransactionRequest.newBuilder().setSessionId(this.id).setTxSettings(SessionImpl.txSettings(transactionMode)).build();
        return this.interceptResult((CompletableFuture)this.tableRpc.beginTransaction(request).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.operationTray.waitResult(((YdbTable.BeginTransactionResponse)response.expect("beginTransaction()")).getOperation(), YdbTable.BeginTransactionResult.class, result -> new TransactionImpl(this, result.getTxMeta().getId()));
        }));
    }

    CompletableFuture<Status> commitTransaction(String txId, CommitTxSettings settings) {
        YdbTable.CommitTransactionRequest request = YdbTable.CommitTransactionRequest.newBuilder().setSessionId(this.id).setTxId(txId).build();
        return this.interceptStatus((CompletableFuture<Status>)this.tableRpc.commitTransaction(request).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.tableRpc.getOperationTray().waitStatus(((YdbTable.CommitTransactionResponse)response.expect("commitTransaction()")).getOperation());
        }));
    }

    CompletableFuture<Status> rollbackTransaction(String txId, RollbackTxSettings settings) {
        YdbTable.RollbackTransactionRequest request = YdbTable.RollbackTransactionRequest.newBuilder().setSessionId(this.id).setTxId(txId).build();
        return this.interceptStatus((CompletableFuture<Status>)this.tableRpc.rollbackTransaction(request).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.tableRpc.getOperationTray().waitStatus(((YdbTable.RollbackTransactionResponse)response.expect("rollbackTransaction()")).getOperation());
        }));
    }

    @Override
    public CompletableFuture<Result<SessionStatus>> keepAlive(KeepAliveSessionSettings settings) {
        YdbTable.KeepAliveRequest request = YdbTable.KeepAliveRequest.newBuilder().setSessionId(this.id).build();
        return this.interceptResult((CompletableFuture)this.tableRpc.keepAlive(request).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.operationTray.waitResult(((YdbTable.KeepAliveResponse)response.expect("keepAlive()")).getOperation(), YdbTable.KeepAliveResult.class, SessionImpl::mapSessionStatus);
        }));
    }

    private static SessionStatus mapSessionStatus(YdbTable.KeepAliveResult result) {
        switch (result.getSessionStatus()) {
            case UNRECOGNIZED: 
            case SESSION_STATUS_UNSPECIFIED: {
                return SessionStatus.UNSPECIFIED;
            }
            case SESSION_STATUS_BUSY: {
                return SessionStatus.BUSY;
            }
            case SESSION_STATUS_READY: {
                return SessionStatus.READY;
            }
        }
        throw new IllegalStateException("unknown session status: " + result.getSessionStatus());
    }

    @Override
    public void invalidateQueryCache() {
        if (this.queryCache != null) {
            this.queryCache.clear();
        }
    }

    @Override
    public boolean release() {
        if (this.sessionPool != null) {
            this.sessionPool.release(this);
        }
        return false;
    }

    @Override
    public CompletableFuture<Status> close(CloseSessionSettings settings) {
        YdbTable.DeleteSessionRequest request = YdbTable.DeleteSessionRequest.newBuilder().setSessionId(this.id).build();
        return this.interceptStatus((CompletableFuture<Status>)this.tableRpc.deleteSession(request).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.DeleteSessionResponse)response.expect("deleteSession()")).getOperation());
        }));
    }

    private <T> CompletableFuture<Result<T>> interceptResult(CompletableFuture<Result<T>> future) {
        return future.whenComplete((r, t) -> this.changeSessionState((Throwable)t, r.getCode()));
    }

    private CompletableFuture<Status> interceptStatus(CompletableFuture<Status> future) {
        return future.whenComplete((r, t) -> this.changeSessionState((Throwable)t, r.getCode()));
    }

    private void changeSessionState(Throwable t, StatusCode code) {
        State oldState = this.getState();
        if (t != null) {
            this.switchState(oldState, State.BROKEN);
            return;
        }
        if (code.isTransportError() && code != StatusCode.CLIENT_RESOURCE_EXHAUSTED) {
            this.switchState(oldState, State.DISCONNECTED);
        } else if (code == StatusCode.BAD_SESSION) {
            this.switchState(oldState, State.BROKEN);
        }
    }

    static enum State {
        IDLE,
        BROKEN,
        ACTIVE,
        DISCONNECTED;

    }
}

