/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.impl;

import com.yandex.ydb.table.SessionStatus;
import com.yandex.ydb.table.impl.SessionImpl;
import com.yandex.ydb.table.impl.SessionPoolOptions;
import com.yandex.ydb.table.impl.TableClientImpl;
import com.yandex.ydb.table.impl.pool.AsyncPool;
import com.yandex.ydb.table.impl.pool.FixedAsyncPool;
import com.yandex.ydb.table.impl.pool.PooledObjectHandler;
import com.yandex.ydb.table.settings.CreateSessionSettings;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;

final class SessionPool
implements PooledObjectHandler<SessionImpl> {
    private static final Duration ACQUIRE_TIMEOUT = Duration.ofSeconds(5L);
    private final TableClientImpl tableClient;
    private final AsyncPool<SessionImpl> pool;
    private final Timer timer;

    SessionPool(TableClientImpl tableClient, SessionPoolOptions options) {
        this.tableClient = tableClient;
        this.timer = new HashedWheelTimer((ThreadFactory)new DefaultThreadFactory("SessionPoolTimer"));
        this.pool = new FixedAsyncPool<SessionImpl>(this, this.timer, options.getMinSize(), options.getMaxSize(), options.getMaxSize() * 2, options.getKeepAliveTimeMillis(), options.getMaxIdleTimeMillis());
    }

    @Override
    public CompletableFuture<SessionImpl> create() {
        return this.tableClient.createSessionImpl(new CreateSessionSettings()).thenApply(r -> (SessionImpl)r.expect("cannot create session"));
    }

    @Override
    public CompletableFuture<Void> destroy(SessionImpl s) {
        return s.close().thenAccept(r -> r.expect("cannot close session: " + s.getId()));
    }

    @Override
    public boolean isValid(SessionImpl s) {
        return s.getState() != SessionImpl.State.BROKEN;
    }

    @Override
    public CompletableFuture<Void> keepAlive(SessionImpl s) {
        return s.keepAlive().thenAccept(r -> {
            SessionStatus cfr_ignored_0 = (SessionStatus)((Object)((Object)r.expect("cannot keep alive session: " + s.getId())));
        });
    }

    CompletableFuture<SessionImpl> acquire() {
        return this.pool.acquire(ACQUIRE_TIMEOUT);
    }

    void release(SessionImpl session) {
        this.pool.release(session);
    }

    void close() {
        try {
            this.pool.close();
        }
        finally {
            this.timer.stop();
        }
    }
}

