/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.impl;

import com.google.common.base.Preconditions;
import com.yandex.ydb.table.TableClient;
import com.yandex.ydb.table.impl.SessionPoolOptions;
import com.yandex.ydb.table.impl.TableClientImpl;
import com.yandex.ydb.table.rpc.TableRpc;
import java.util.concurrent.TimeUnit;

public class TableClientBuilderImpl
implements TableClient.Builder {
    protected final TableRpc tableRpc;
    protected int queryCacheSize = 1000;
    protected boolean keepQueryText = true;
    protected SessionPoolOptions sessionPoolOptions = SessionPoolOptions.DEFAULT;

    public TableClientBuilderImpl(TableRpc tableRpc) {
        this.tableRpc = tableRpc;
    }

    @Override
    public TableClient.Builder queryCacheSize(int size) {
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (String)"queryCacheSize(%d) is negative", (int)size);
        this.queryCacheSize = size;
        return this;
    }

    @Override
    public TableClient.Builder keepQueryText(boolean keep) {
        this.keepQueryText = keep;
        return this;
    }

    @Override
    public TableClient.Builder sessionPoolSize(int minSize, int maxSize) {
        Preconditions.checkArgument((minSize >= 0 ? 1 : 0) != 0, (String)"sessionPoolMinSize(%d) is negative", (int)minSize);
        Preconditions.checkArgument((maxSize >= 0 ? 1 : 0) != 0, (String)"sessionPoolMaxSize(%d) is negative", (int)maxSize);
        Preconditions.checkArgument((minSize <= maxSize ? 1 : 0) != 0, (String)"sessionPoolMinSize(%d) is greater than sessionPoolMaxSize(%d)", (int)minSize, (int)maxSize);
        this.sessionPoolOptions = this.sessionPoolOptions.withSize(minSize, maxSize);
        return this;
    }

    @Override
    public TableClient.Builder sessionKeepAliveTime(long time, TimeUnit timeUnit) {
        Preconditions.checkArgument((time >= 0L ? 1 : 0) != 0, (String)"sessionKeepAliveTime(%d, %s) is negative", (long)time, (Object)((Object)timeUnit));
        long timeMillis = timeUnit.toMillis(time);
        Preconditions.checkArgument((timeMillis >= TimeUnit.SECONDS.toMillis(1L) ? 1 : 0) != 0, (String)"sessionKeepAliveTime(%d, %s) is less than 1 second", (long)time, (Object)((Object)timeUnit));
        Preconditions.checkArgument((timeMillis <= TimeUnit.MINUTES.toMillis(30L) ? 1 : 0) != 0, (String)"sessionKeepAliveTime(%d, %s) is greater than 30 minutes", (long)time, (Object)((Object)timeUnit));
        this.sessionPoolOptions = this.sessionPoolOptions.withKeepAliveTimeMillis(timeMillis);
        return this;
    }

    @Override
    public TableClient.Builder sessionMaxIdleTime(long time, TimeUnit timeUnit) {
        Preconditions.checkArgument((time >= 0L ? 1 : 0) != 0, (String)"sessionMaxIdleTime(%d, %s) is negative", (long)time, (Object)((Object)timeUnit));
        long timeMillis = timeUnit.toMillis(time);
        Preconditions.checkArgument((timeMillis >= TimeUnit.SECONDS.toMillis(1L) ? 1 : 0) != 0, (String)"sessionMaxIdleTime(%d, %s) is less than 1 second", (long)time, (Object)((Object)timeUnit));
        Preconditions.checkArgument((timeMillis <= TimeUnit.MINUTES.toMillis(30L) ? 1 : 0) != 0, (String)"sessionMaxIdleTime(%d, %s) is greater than 30 minutes", (long)time, (Object)((Object)timeUnit));
        this.sessionPoolOptions = this.sessionPoolOptions.withMaxIdleTimeMillis(timeMillis);
        return this;
    }

    @Override
    public TableClient.Builder sessionCreationMaxRetries(int maxRetries) {
        Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0, (String)"sessionCreationMaxRetries(%d) is negative", (int)maxRetries);
        this.sessionPoolOptions = this.sessionPoolOptions.withCreationMaxRetries(maxRetries);
        return this;
    }

    @Override
    public TableClient build() {
        return new TableClientImpl(this);
    }
}

