/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.rpc.grpc;

import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.grpc.GrpcTransport;
import com.yandex.ydb.core.rpc.OperationTray;
import com.yandex.ydb.core.rpc.RpcTransport;
import com.yandex.ydb.scheme.SchemeOperationProtos;
import com.yandex.ydb.scheme.v1.SchemeServiceGrpc;
import com.yandex.ydb.table.rpc.SchemeRpc;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;

@ParametersAreNonnullByDefault
public final class GrpcSchemeRpc
implements SchemeRpc {
    private final GrpcTransport transport;
    private final boolean transportOwned;

    private GrpcSchemeRpc(GrpcTransport transport, boolean transportOwned) {
        this.transport = transport;
        this.transportOwned = transportOwned;
    }

    @Nullable
    public static GrpcSchemeRpc useTransport(@WillNotClose RpcTransport transport) {
        if (transport instanceof GrpcTransport) {
            return new GrpcSchemeRpc((GrpcTransport)transport, false);
        }
        return null;
    }

    @Nullable
    public static GrpcSchemeRpc ownTransport(@WillClose RpcTransport transport) {
        if (transport instanceof GrpcTransport) {
            return new GrpcSchemeRpc((GrpcTransport)transport, true);
        }
        return null;
    }

    @Override
    public CompletableFuture<Result<SchemeOperationProtos.MakeDirectoryResponse>> makeDirectory(SchemeOperationProtos.MakeDirectoryRequest request) {
        return this.transport.unaryCall(SchemeServiceGrpc.METHOD_MAKE_DIRECTORY, (Object)request);
    }

    @Override
    public CompletableFuture<Result<SchemeOperationProtos.RemoveDirectoryResponse>> removeDirectory(SchemeOperationProtos.RemoveDirectoryRequest request) {
        return this.transport.unaryCall(SchemeServiceGrpc.METHOD_REMOVE_DIRECTORY, (Object)request);
    }

    @Override
    public CompletableFuture<Result<SchemeOperationProtos.ListDirectoryResponse>> describeDirectory(SchemeOperationProtos.ListDirectoryRequest request) {
        return this.transport.unaryCall(SchemeServiceGrpc.METHOD_LIST_DIRECTORY, (Object)request);
    }

    @Override
    public CompletableFuture<Result<SchemeOperationProtos.DescribePathResponse>> describePath(SchemeOperationProtos.DescribePathRequest request) {
        return this.transport.unaryCall(SchemeServiceGrpc.METHOD_DESCRIBE_PATH, (Object)request);
    }

    public OperationTray getOperationTray() {
        return this.transport.getOperationTray();
    }

    public void close() {
        if (this.transportOwned) {
            this.transport.close();
        }
    }
}

