/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.rpc.grpc;

import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.grpc.GrpcTransport;
import com.yandex.ydb.core.rpc.OperationTray;
import com.yandex.ydb.core.rpc.RpcTransport;
import com.yandex.ydb.table.YdbTable;
import com.yandex.ydb.table.rpc.TableRpc;
import com.yandex.ydb.table.v1.TableServiceGrpc;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;

@ParametersAreNonnullByDefault
public final class GrpcTableRpc
implements TableRpc {
    private final GrpcTransport transport;
    private final boolean transportOwned;

    private GrpcTableRpc(GrpcTransport transport, boolean transportOwned) {
        this.transport = transport;
        this.transportOwned = transportOwned;
    }

    @Nullable
    public static GrpcTableRpc useTransport(@WillNotClose RpcTransport transport) {
        if (transport instanceof GrpcTransport) {
            return new GrpcTableRpc((GrpcTransport)transport, false);
        }
        return null;
    }

    @Nullable
    public static GrpcTableRpc ownTransport(@WillClose RpcTransport transport) {
        if (transport instanceof GrpcTransport) {
            return new GrpcTableRpc((GrpcTransport)transport, true);
        }
        return null;
    }

    @Override
    public CompletableFuture<Result<YdbTable.CreateSessionResponse>> createSession(YdbTable.CreateSessionRequest request) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_CREATE_SESSION, (Object)request);
    }

    @Override
    public CompletableFuture<Result<YdbTable.DeleteSessionResponse>> deleteSession(YdbTable.DeleteSessionRequest request) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_DELETE_SESSION, (Object)request);
    }

    @Override
    public CompletableFuture<Result<YdbTable.KeepAliveResponse>> keepAlive(YdbTable.KeepAliveRequest request) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_KEEP_ALIVE, (Object)request);
    }

    @Override
    public CompletableFuture<Result<YdbTable.CreateTableResponse>> createTable(YdbTable.CreateTableRequest request) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_CREATE_TABLE, (Object)request);
    }

    @Override
    public CompletableFuture<Result<YdbTable.DropTableResponse>> dropTable(YdbTable.DropTableRequest request) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_DROP_TABLE, (Object)request);
    }

    @Override
    public CompletableFuture<Result<YdbTable.AlterTableResponse>> alterTable(YdbTable.AlterTableRequest request) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_ALTER_TABLE, (Object)request);
    }

    @Override
    public CompletableFuture<Result<YdbTable.CopyTableResponse>> copyTable(YdbTable.CopyTableRequest request) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_COPY_TABLE, (Object)request);
    }

    @Override
    public CompletableFuture<Result<YdbTable.DescribeTableResponse>> describeTable(YdbTable.DescribeTableRequest request) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_DESCRIBE_TABLE, (Object)request);
    }

    @Override
    public CompletableFuture<Result<YdbTable.ExplainDataQueryResponse>> explainDataQuery(YdbTable.ExplainDataQueryRequest request) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_EXPLAIN_DATA_QUERY, (Object)request);
    }

    @Override
    public CompletableFuture<Result<YdbTable.PrepareDataQueryResponse>> prepareDataQuery(YdbTable.PrepareDataQueryRequest request) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_PREPARE_DATA_QUERY, (Object)request);
    }

    @Override
    public CompletableFuture<Result<YdbTable.ExecuteDataQueryResponse>> executeDataQuery(YdbTable.ExecuteDataQueryRequest request) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_EXECUTE_DATA_QUERY, (Object)request);
    }

    @Override
    public CompletableFuture<Result<YdbTable.ExecuteSchemeQueryResponse>> executeSchemeQuery(YdbTable.ExecuteSchemeQueryRequest request) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_EXECUTE_SCHEME_QUERY, (Object)request);
    }

    @Override
    public CompletableFuture<Result<YdbTable.BeginTransactionResponse>> beginTransaction(YdbTable.BeginTransactionRequest request) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_BEGIN_TRANSACTION, (Object)request);
    }

    @Override
    public CompletableFuture<Result<YdbTable.CommitTransactionResponse>> commitTransaction(YdbTable.CommitTransactionRequest request) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_COMMIT_TRANSACTION, (Object)request);
    }

    @Override
    public CompletableFuture<Result<YdbTable.RollbackTransactionResponse>> rollbackTransaction(YdbTable.RollbackTransactionRequest request) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_ROLLBACK_TRANSACTION, (Object)request);
    }

    public OperationTray getOperationTray() {
        return this.transport.getOperationTray();
    }

    public void close() {
        if (this.transportOwned) {
            this.transport.close();
        }
    }
}

