/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.types;

import com.google.common.base.Preconditions;
import com.yandex.ydb.table.types.Type;

public class DecimalType
implements Type {
    public static final int MAX_PRECISION = 35;
    private static final DecimalType DEFAULT_TYPE = DecimalType.of(35);
    private final byte precision;
    private final byte scale;

    private DecimalType(byte precision, byte scale) {
        this.precision = precision;
        this.scale = scale;
    }

    public static DecimalType of() {
        return DEFAULT_TYPE;
    }

    public static DecimalType of(int precision) {
        return DecimalType.of(precision, 0);
    }

    public static DecimalType of(int precision, int scale) {
        Preconditions.checkArgument((precision >= 1 && precision <= 35 ? 1 : 0) != 0, (String)"precision (%s) is out of range [1, %s]", (int)precision, (int)35);
        Preconditions.checkArgument((scale >= 0 && scale <= precision ? 1 : 0) != 0, (String)"scale (%s) is out of range [0, %s]", (int)scale, (int)precision);
        return new DecimalType((byte)precision, (byte)scale);
    }

    @Override
    public Type.Kind getKind() {
        return Type.Kind.DECIMAL;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecimalType that = (DecimalType)o;
        if (this.precision != that.precision) {
            return false;
        }
        return this.scale == that.scale;
    }

    @Override
    public int hashCode() {
        return 31 * this.precision + this.scale;
    }

    @Override
    public String toString() {
        return "Decimal(" + this.precision + ", " + this.scale + ')';
    }
}

