/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.types;

import com.yandex.ydb.table.types.Type;

public final class DictType
implements Type {
    private final Type keyType;
    private final Type valueType;

    private DictType(Type keyType, Type valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public static DictType of(Type keyType, Type valueType) {
        return new DictType(keyType, valueType);
    }

    @Override
    public Type.Kind getKind() {
        return Type.Kind.DICT;
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Type getValueType() {
        return this.valueType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != DictType.class) {
            return false;
        }
        DictType dictType = (DictType)o;
        return this.keyType.equals(dictType.getKeyType()) && this.valueType.equals(dictType.getKeyType());
    }

    @Override
    public int hashCode() {
        int result = Type.Kind.DICT.hashCode();
        result = 31 * result + this.keyType.hashCode();
        result = 31 * result + this.valueType.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "Dict<" + this.keyType + ", " + this.valueType + '>';
    }
}

