/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.types;

import com.yandex.ydb.table.types.Type;

public final class PrimitiveType
implements Type {
    private static final PrimitiveType BOOL = new PrimitiveType(Id.Bool);
    private static final PrimitiveType INT_8 = new PrimitiveType(Id.Int8);
    private static final PrimitiveType UINT_8 = new PrimitiveType(Id.Uint8);
    private static final PrimitiveType INT_16 = new PrimitiveType(Id.Int16);
    private static final PrimitiveType UINT_16 = new PrimitiveType(Id.Uint16);
    private static final PrimitiveType INT_32 = new PrimitiveType(Id.Int32);
    private static final PrimitiveType UINT_32 = new PrimitiveType(Id.Uint32);
    private static final PrimitiveType INT_64 = new PrimitiveType(Id.Int64);
    private static final PrimitiveType UINT_64 = new PrimitiveType(Id.Uint64);
    private static final PrimitiveType FLOAT = new PrimitiveType(Id.Float);
    private static final PrimitiveType DOUBLE = new PrimitiveType(Id.Double);
    private static final PrimitiveType STRING = new PrimitiveType(Id.String);
    private static final PrimitiveType UTF_8 = new PrimitiveType(Id.Utf8);
    private static final PrimitiveType YSON = new PrimitiveType(Id.Yson);
    private static final PrimitiveType JSON = new PrimitiveType(Id.Json);
    private static final PrimitiveType UUID = new PrimitiveType(Id.Uuid);
    private static final PrimitiveType DATE = new PrimitiveType(Id.Date);
    private static final PrimitiveType DATETIME = new PrimitiveType(Id.Datetime);
    private static final PrimitiveType TIMESTAMP = new PrimitiveType(Id.Timestamp);
    private static final PrimitiveType INTERVAL = new PrimitiveType(Id.Interval);
    private static final PrimitiveType TZ_DATE = new PrimitiveType(Id.TzDate);
    private static final PrimitiveType TZ_DATETIME = new PrimitiveType(Id.TzDatetime);
    private static final PrimitiveType TZ_TIMESTAMP = new PrimitiveType(Id.TzTimestamp);
    private static final PrimitiveType[] BY_IDS;
    private final Id id;

    public static PrimitiveType of(Id id) {
        return BY_IDS[id.ordinal()];
    }

    public static PrimitiveType bool() {
        return BOOL;
    }

    public static PrimitiveType int8() {
        return INT_8;
    }

    public static PrimitiveType uint8() {
        return UINT_8;
    }

    public static PrimitiveType int16() {
        return INT_16;
    }

    public static PrimitiveType uint16() {
        return UINT_16;
    }

    public static PrimitiveType int32() {
        return INT_32;
    }

    public static PrimitiveType uint32() {
        return UINT_32;
    }

    public static PrimitiveType int64() {
        return INT_64;
    }

    public static PrimitiveType uint64() {
        return UINT_64;
    }

    public static PrimitiveType float32() {
        return FLOAT;
    }

    public static PrimitiveType float64() {
        return DOUBLE;
    }

    public static PrimitiveType string() {
        return STRING;
    }

    public static PrimitiveType utf8() {
        return UTF_8;
    }

    public static PrimitiveType yson() {
        return YSON;
    }

    public static PrimitiveType json() {
        return JSON;
    }

    public static PrimitiveType uuid() {
        return UUID;
    }

    public static PrimitiveType date() {
        return DATE;
    }

    public static PrimitiveType datetime() {
        return DATETIME;
    }

    public static PrimitiveType timestamp() {
        return TIMESTAMP;
    }

    public static PrimitiveType interval() {
        return INTERVAL;
    }

    public static PrimitiveType tzDate() {
        return TZ_DATE;
    }

    public static PrimitiveType tzDatetime() {
        return TZ_DATETIME;
    }

    public static PrimitiveType tzTimestamp() {
        return TZ_TIMESTAMP;
    }

    private PrimitiveType(Id id) {
        this.id = id;
    }

    @Override
    public Type.Kind getKind() {
        return Type.Kind.PRIMITIVE;
    }

    public Id getId() {
        return this.id;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return 31 * Type.Kind.PRIMITIVE.hashCode() + this.id.hashCode();
    }

    @Override
    public String toString() {
        return this.id.name();
    }

    private static PrimitiveType byId(Id id) {
        switch (id) {
            case Bool: {
                return BOOL;
            }
            case Int8: {
                return INT_8;
            }
            case Uint8: {
                return UINT_8;
            }
            case Int16: {
                return INT_16;
            }
            case Uint16: {
                return UINT_16;
            }
            case Int32: {
                return INT_32;
            }
            case Uint32: {
                return UINT_32;
            }
            case Int64: {
                return INT_64;
            }
            case Uint64: {
                return UINT_64;
            }
            case Float: {
                return FLOAT;
            }
            case Double: {
                return DOUBLE;
            }
            case String: {
                return STRING;
            }
            case Utf8: {
                return UTF_8;
            }
            case Yson: {
                return YSON;
            }
            case Json: {
                return JSON;
            }
            case Uuid: {
                return UUID;
            }
            case Date: {
                return DATE;
            }
            case Datetime: {
                return DATETIME;
            }
            case Timestamp: {
                return TIMESTAMP;
            }
            case Interval: {
                return INTERVAL;
            }
            case TzDate: {
                return TZ_DATE;
            }
            case TzDatetime: {
                return TZ_DATETIME;
            }
            case TzTimestamp: {
                return TZ_TIMESTAMP;
            }
        }
        throw new IllegalArgumentException("unknown PrimitiveType: " + (Object)((Object)id));
    }

    static {
        Id[] ids = Id.values();
        BY_IDS = new PrimitiveType[ids.length];
        for (Id id : ids) {
            PrimitiveType.BY_IDS[id.ordinal()] = PrimitiveType.byId(id);
        }
    }

    public static enum Id {
        Bool(6),
        Int8(7),
        Uint8(5),
        Int16(8),
        Uint16(9),
        Int32(1),
        Uint32(2),
        Int64(3),
        Uint64(4),
        Float(33),
        Double(32),
        String(4097),
        Utf8(4608),
        Yson(4609),
        Json(4610),
        Uuid(4611),
        Date(48),
        Datetime(49),
        Timestamp(50),
        Interval(51),
        TzDate(52),
        TzDatetime(53),
        TzTimestamp(54);

        private final short numId;

        private Id(int numId) {
            this.numId = (short)numId;
        }

        public short getNumId() {
            return this.numId;
        }
    }
}

