/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.types;

import com.yandex.ydb.table.types.Type;
import java.util.Arrays;
import java.util.List;

public final class TupleType
implements Type {
    private static final TupleType EMPTY = new TupleType(new Type[0]);
    private final Type[] elementTypes;

    private TupleType(Type[] elementTypes) {
        this.elementTypes = elementTypes;
    }

    public static TupleType empty() {
        return EMPTY;
    }

    public static TupleType of() {
        return EMPTY;
    }

    public static TupleType of(Type elementType) {
        return new TupleType(new Type[]{elementType});
    }

    public static TupleType of(Type ... elementTypes) {
        return new TupleType((Type[])elementTypes.clone());
    }

    public static TupleType ofOwning(Type ... elementTypes) {
        return new TupleType(elementTypes);
    }

    public static TupleType of(List<Type> elementTypes) {
        return new TupleType(elementTypes.toArray(new Type[0]));
    }

    public int getElementsCount() {
        return this.elementTypes.length;
    }

    public Type getElementType(int index) {
        return this.elementTypes[index];
    }

    @Override
    public Type.Kind getKind() {
        return Type.Kind.TUPLE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != TupleType.class) {
            return false;
        }
        TupleType tupleType = (TupleType)o;
        if (this.getElementsCount() != tupleType.getElementsCount()) {
            return false;
        }
        for (int i = 0; i < this.getElementsCount(); ++i) {
            if (this.elementTypes[i].equals(tupleType.getElementType(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return 31 * Type.Kind.TUPLE.hashCode() + Arrays.hashCode(this.elementTypes);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Tuple<");
        for (Type elementType : this.elementTypes) {
            sb.append(elementType).append(", ");
        }
        if (this.elementTypes.length != 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('>');
        return sb.toString();
    }
}

