/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.values;

import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.types.DecimalType;
import com.yandex.ydb.table.values.Value;
import com.yandex.ydb.table.values.proto.ProtoValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

public class DecimalValue
implements Value<DecimalType> {
    private static final long LONG_MASK = 0xFFFFFFFFL;
    private static final long LONG_SIGN_BIT = Long.MIN_VALUE;
    private static final long LONG_MAX_DIGITS = 18L;
    public static final DecimalValue INF = new DecimalValue(DecimalType.of(), 5421010862427522L, 3136633892082024448L);
    public static final DecimalValue NEG_INF = new DecimalValue(DecimalType.of(), -5421010862427523L, -3136633892082024448L);
    public static final DecimalValue NAN = new DecimalValue(DecimalType.of(), 5421010862427522L, 3136633892082024449L);
    public static final DecimalValue ZERO = new DecimalValue(DecimalType.of(), 0L, 0L);
    private final DecimalType type;
    private final long high;
    private final long low;

    private DecimalValue(DecimalType type, long high, long low) {
        this.type = type;
        this.high = high;
        this.low = low;
    }

    public static DecimalValue of(DecimalType type, long high, long low) {
        if (high == 0L && low == 0L) {
            return ZERO;
        }
        if (DecimalValue.NAN.high == high && DecimalValue.NAN.low == low) {
            return NAN;
        }
        if (high > DecimalValue.INF.high || high == DecimalValue.INF.high && Long.compareUnsigned(low, DecimalValue.INF.low) >= 0) {
            return INF;
        }
        if (high < DecimalValue.NEG_INF.high || high == DecimalValue.NEG_INF.high && Long.compareUnsigned(low, DecimalValue.NEG_INF.low) <= 0) {
            return NEG_INF;
        }
        return new DecimalValue(type, high, low);
    }

    public static DecimalValue of(DecimalType type, long value) {
        if (value == 0L) {
            return ZERO;
        }
        long high = value > 0L ? 0L : -1L;
        return new DecimalValue(type, high, value);
    }

    public static DecimalValue ofUnsigned(DecimalType type, long value) {
        if (value == 0L) {
            return ZERO;
        }
        return new DecimalValue(type, 0L, value);
    }

    public static DecimalValue of(DecimalType type, BigInteger value) {
        boolean negative;
        int bitLength = value.bitLength();
        if (bitLength < 64) {
            return DecimalValue.of(type, value.longValue());
        }
        boolean bl = negative = value.signum() < 0;
        if (bitLength > 128) {
            return negative ? NEG_INF : INF;
        }
        byte[] buf = value.abs().toByteArray();
        long high = DecimalValue.getLongBe(buf, 0, buf.length - 8);
        long low = DecimalValue.getLongBe(buf, buf.length - 8, buf.length);
        if (negative && (high != Long.MIN_VALUE || low != 0L)) {
            high ^= 0xFFFFFFFFFFFFFFFFL;
            low ^= 0xFFFFFFFFFFFFFFFFL;
            if (++low == 0L) {
                ++high;
            }
        }
        return DecimalValue.of(type, high, low);
    }

    public static DecimalValue of(DecimalType type, BigDecimal value) {
        return DecimalValue.of(type, value.unscaledValue());
    }

    public static DecimalValue of(DecimalType type, String value) {
        int scaleAdjust;
        if (value.isEmpty()) {
            throw new NumberFormatException("cannot parse decimal from empty string");
        }
        int end = value.length();
        int cursor = 0;
        boolean negative = false;
        if (value.charAt(cursor) == '+') {
            ++cursor;
        } else if (value.charAt(cursor) == '-') {
            ++cursor;
            negative = true;
        }
        if (end - cursor == 3) {
            char c1 = value.charAt(cursor);
            char c2 = value.charAt(cursor + 1);
            char c3 = value.charAt(cursor + 2);
            if ((c1 == 'i' || c1 == 'I') && (c2 == 'n' || c2 == 'N') || c3 == 'f' || c3 == 'F') {
                return negative ? NEG_INF : INF;
            }
            if ((c1 == 'n' || c1 == 'N') && (c2 == 'a' || c2 == 'A') || c3 == 'n' || c3 == 'N') {
                return NAN;
            }
        }
        while (cursor < end && value.charAt(cursor) == '0') {
            ++cursor;
        }
        if (cursor == end) {
            return ZERO;
        }
        long accumulated = 0L;
        int accumulatedCount = 0;
        boolean fractional = false;
        int fractionalDigits = 0;
        BigInteger unscaledValue = BigInteger.ZERO;
        while (cursor < end) {
            char ch = value.charAt(cursor);
            if (ch >= '0' && ch <= '9') {
                if ((long)accumulatedCount == 18L) {
                    if (unscaledValue == BigInteger.ZERO) {
                        unscaledValue = BigInteger.valueOf(accumulated);
                    } else {
                        unscaledValue = unscaledValue.multiply(BigInteger.TEN.pow(accumulatedCount));
                        unscaledValue = unscaledValue.add(BigInteger.valueOf(accumulated));
                    }
                    accumulated = 0L;
                    accumulatedCount = 0;
                }
                int digit = ch - 48;
                accumulated = accumulated * 10L + (long)digit;
                ++accumulatedCount;
                if (fractional) {
                    ++fractionalDigits;
                }
            } else if (ch == '.') {
                if (fractional) {
                    throw new NumberFormatException("invalid string: " + value);
                }
                fractional = true;
            } else {
                throw new NumberFormatException("invalid string: " + value);
            }
            ++cursor;
        }
        if (accumulatedCount > 0) {
            if (unscaledValue == BigInteger.ZERO) {
                unscaledValue = BigInteger.valueOf(accumulated);
            } else {
                unscaledValue = unscaledValue.multiply(BigInteger.TEN.pow(accumulatedCount));
                unscaledValue = unscaledValue.add(BigInteger.valueOf(accumulated));
            }
        }
        if ((scaleAdjust = type.getScale() - fractionalDigits) > 0) {
            unscaledValue = unscaledValue.multiply(BigInteger.TEN.pow(scaleAdjust));
        } else if (scaleAdjust < 0) {
            unscaledValue = unscaledValue.divide(BigInteger.TEN.pow(-scaleAdjust));
        }
        if (negative) {
            unscaledValue = unscaledValue.negate();
        }
        return DecimalValue.of(type, unscaledValue);
    }

    public DecimalType getType() {
        return this.type;
    }

    public long getHigh() {
        return this.high;
    }

    public long getLow() {
        return this.low;
    }

    public boolean isInf() {
        return this == INF;
    }

    public boolean isNegativeInf() {
        return this == NEG_INF;
    }

    public boolean isNan() {
        return this == NAN;
    }

    public boolean isZero() {
        return this == ZERO;
    }

    public boolean isNegative() {
        return (this.high & Long.MIN_VALUE) != 0L;
    }

    public BigInteger toBigInteger() {
        if (this.isZero()) {
            return BigInteger.ZERO;
        }
        if (this.high == 0L && this.low > 0L) {
            return BigInteger.valueOf(this.low);
        }
        byte[] buf = new byte[16];
        DecimalValue.putLongBe(buf, 0, this.high);
        DecimalValue.putLongBe(buf, 8, this.low);
        return new BigInteger(buf);
    }

    public BigDecimal toBigDecimal() {
        if (this.isZero()) {
            return BigDecimal.ZERO;
        }
        MathContext mc = new MathContext(this.type.getPrecision(), RoundingMode.HALF_EVEN);
        return new BigDecimal(this.toBigInteger(), this.type.getScale(), mc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecimalValue that = (DecimalValue)o;
        if (this.high != that.high) {
            return false;
        }
        if (this.low != that.low) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (int)(this.high ^ this.high >>> 32);
        result = 31 * result + (int)(this.low ^ this.low >>> 32);
        return result;
    }

    public String toString() {
        if (this.isInf()) {
            return "inf";
        }
        if (this.isNegativeInf()) {
            return "-inf";
        }
        if (this.isNan()) {
            return "nan";
        }
        if (this.isZero()) {
            return "0";
        }
        StringBuilder sb = new StringBuilder(39);
        this.writeAsString(sb, this.type.getScale());
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
        if (this.isInf()) {
            sb.append("inf");
        }
        if (this.isNegativeInf()) {
            sb.append("-inf");
        }
        if (this.isNan()) {
            sb.append("nan");
        }
        if (this.isZero()) {
            sb.append("0");
        }
        this.writeAsString(sb, this.type.getScale());
    }

    public String toUnscaledString() {
        if (this.isZero()) {
            return "0";
        }
        StringBuilder sb = new StringBuilder(37);
        this.writeAsString(sb, 0);
        return sb.toString();
    }

    private void writeAsString(StringBuilder sb, int scale) {
        long high = this.high;
        long low = this.low;
        boolean dot = false;
        if ((high & Long.MIN_VALUE) != 0L && (high != Long.MIN_VALUE || low != 0L)) {
            high ^= 0xFFFFFFFFFFFFFFFFL;
            low ^= 0xFFFFFFFFFFFFFFFFL;
            if (++low == 0L) {
                ++high;
            }
        }
        long lowHi = low >>> 32;
        long lowLo = low & 0xFFFFFFFFL;
        int divisor = 10;
        do {
            long remainder = high % 10L;
            high /= 10L;
            remainder = lowHi + (remainder << 32);
            lowHi = remainder / 10L;
            remainder %= 10L;
            remainder = lowLo + (remainder << 32);
            lowLo = remainder / 10L;
            sb.append((char)(48L + remainder % 10L));
            if (--scale != 0) continue;
            sb.append('.');
            dot = true;
        } while (high != 0L || lowHi != 0L || lowLo != 0L);
        if (dot && scale == 0) {
            sb.append('0');
        } else if (!dot && scale > 0) {
            while (scale-- > 0) {
                sb.append('0');
            }
            sb.append('.');
            sb.append('0');
        }
        if (this.isNegative()) {
            sb.append('-');
        }
        sb.reverse();
    }

    @Override
    public ValueProtos.Value toPb(DecimalType type) {
        if (!this.type.equals(type)) {
            throw new IllegalArgumentException("types mismatch, expected " + type + ", but was " + this.type);
        }
        return ProtoValue.decimal(this.high, this.low);
    }

    private static long getLongBe(byte[] buf, int from, int to) {
        long r = 0L;
        for (int i = from; i < to; ++i) {
            r = r << 8 | (long)(buf[i] & 0xFF);
        }
        return r;
    }

    private static void putLongBe(byte[] buf, int index, long value) {
        buf[index] = (byte)(value >>> 56 & 0xFFL);
        buf[index + 1] = (byte)(value >>> 48 & 0xFFL);
        buf[index + 2] = (byte)(value >>> 40 & 0xFFL);
        buf[index + 3] = (byte)(value >>> 32 & 0xFFL);
        buf[index + 4] = (byte)(value >>> 24 & 0xFFL);
        buf[index + 5] = (byte)(value >>> 16 & 0xFFL);
        buf[index + 6] = (byte)(value >>> 8 & 0xFFL);
        buf[index + 7] = (byte)(value & 0xFFL);
    }
}

