/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.values;

import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.types.ListType;
import com.yandex.ydb.table.types.Type;
import com.yandex.ydb.table.values.Value;
import com.yandex.ydb.table.values.proto.ProtoValue;
import java.util.Arrays;
import java.util.Collection;

public class ListValue
implements Value<ListType> {
    private static final ListValue EMPTY = new ListValue(new Value[0]);
    private final Value[] items;

    private ListValue(Value[] items) {
        this.items = items;
    }

    public static ListValue of() {
        return EMPTY;
    }

    public static ListValue of(Value item) {
        return new ListValue(new Value[]{item});
    }

    public static ListValue of(Value a, Value b) {
        return new ListValue(new Value[]{a, b});
    }

    public static ListValue of(Value a, Value b, Value c) {
        return new ListValue(new Value[]{a, b, c});
    }

    public static ListValue of(Value a, Value b, Value c, Value d) {
        return new ListValue(new Value[]{a, b, c, d});
    }

    public static ListValue of(Value a, Value b, Value c, Value d, Value e) {
        return new ListValue(new Value[]{a, b, c, d, e});
    }

    public static ListValue of(Collection<Value> items) {
        if (items.isEmpty()) {
            return EMPTY;
        }
        return new ListValue(items.toArray(new Value[items.size()]));
    }

    public static ListValue fromArrayCopy(Value ... items) {
        if (items.length == 0) {
            return EMPTY;
        }
        return new ListValue((Value[])items.clone());
    }

    public static ListValue fromArrayOwn(Value ... items) {
        if (items.length == 0) {
            return EMPTY;
        }
        return new ListValue(items);
    }

    public int size() {
        return this.items.length;
    }

    public boolean isEmpty() {
        return this.items.length == 0;
    }

    public Value get(int index) {
        return this.items[index];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListValue that = (ListValue)o;
        return Arrays.equals(this.items, that.items);
    }

    public int hashCode() {
        return 31 * Type.Kind.LIST.hashCode() + Arrays.hashCode(this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("List[");
        for (Value item : this.items) {
            sb.append(item).append(", ");
        }
        if (this.items.length > 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public ValueProtos.Value toPb(ListType type) {
        if (this.isEmpty()) {
            return ProtoValue.list();
        }
        Type itemType = type.getItemType();
        ValueProtos.Value.Builder builder = ValueProtos.Value.newBuilder();
        for (Value item : this.items) {
            ValueProtos.Value value = item.toPb(itemType);
            builder.addItems(value);
        }
        return builder.build();
    }
}

