/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.values;

import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.types.OptionalType;
import com.yandex.ydb.table.types.Type;
import com.yandex.ydb.table.values.Value;
import com.yandex.ydb.table.values.proto.ProtoValue;
import java.util.NoSuchElementException;
import java.util.Objects;

public class OptionalValue
implements Value<OptionalType> {
    private static final OptionalValue EMPTY = new OptionalValue();
    private final Value value;

    private OptionalValue() {
        this.value = null;
    }

    private OptionalValue(Value value) {
        this.value = Objects.requireNonNull(value, "value");
    }

    public static OptionalValue empty() {
        return EMPTY;
    }

    public static OptionalValue of(Value value) {
        return new OptionalValue(value);
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public Value get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public Value orElse(Value other) {
        return this.value != null ? this.value : other;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionalValue that = (OptionalValue)o;
        if (this.value == null) {
            return that.value == null;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        if (this.value == null) {
            return 2017;
        }
        return 31 * Type.Kind.OPTIONAL.hashCode() + this.value.hashCode();
    }

    public String toString() {
        if (this.value == null) {
            return "Empty[]";
        }
        return "Some[" + this.value.toString() + ']';
    }

    @Override
    public ValueProtos.Value toPb(OptionalType type) {
        if (this.isPresent()) {
            Type itemType = type.getItemType();
            ValueProtos.Value value = this.get().toPb(itemType);
            return ProtoValue.optional(value);
        }
        return ProtoValue.optional();
    }
}

