/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.values;

import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.types.Type;
import com.yandex.ydb.table.types.VariantType;
import com.yandex.ydb.table.values.Value;
import java.util.Objects;

public class VariantValue
implements Value<VariantType> {
    private final int typeIndex;
    private final Value item;

    private VariantValue(int typeIndex, Value item) {
        this.typeIndex = typeIndex;
        this.item = Objects.requireNonNull(item, "item");
    }

    public static VariantValue of(int typeIndex, Value item) {
        return new VariantValue(typeIndex, item);
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public Value getItem() {
        return this.item;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariantValue that = (VariantValue)o;
        if (this.typeIndex != that.typeIndex) {
            return false;
        }
        return this.item.equals(that.item);
    }

    public int hashCode() {
        int h = Type.Kind.VARIANT.hashCode();
        h = 31 * h + this.typeIndex;
        return 31 * h + this.item.hashCode();
    }

    public String toString() {
        return "Variant[" + this.typeIndex + "; " + this.item.toString() + ']';
    }

    @Override
    public ValueProtos.Value toPb(VariantType type) {
        Type itemType = type.getItemType(this.typeIndex);
        ValueProtos.Value itemValue = this.item.toPb(itemType);
        ValueProtos.Value.Builder builder = ValueProtos.Value.newBuilder();
        builder.setVariantIndex(this.typeIndex);
        builder.setNestedValue(itemValue);
        return builder.build();
    }
}

