/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.values;

import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.values.ListType;
import com.yandex.ydb.table.values.Type;
import com.yandex.ydb.table.values.Value;
import com.yandex.ydb.table.values.VoidType;
import com.yandex.ydb.table.values.proto.ProtoValue;
import java.util.Arrays;

public class ListValue
implements Value<ListType> {
    private final ListType type;
    private final Value[] items;

    ListValue(ListType type, Value ... items) {
        this.type = type;
        this.items = items;
    }

    public static ListValue empty(Type type) {
        return new ListValue(ListType.of(type), new Value[0]);
    }

    public static ListValue of(Value ... items) {
        if (items.length == 0) {
            return new ListValue(ListType.of(VoidType.of()), new Value[0]);
        }
        return new ListValue(ListType.of(items[0].getType()), items);
    }

    public static ListValue of(Value item) {
        return new ListValue(ListType.of(item.getType()), item);
    }

    public static ListValue of(Value a, Value b) {
        return new ListValue(ListType.of(a.getType()), a, b);
    }

    public static ListValue of(Value a, Value b, Value c) {
        return new ListValue(ListType.of(a.getType()), a, b, c);
    }

    public static ListValue of(Value a, Value b, Value c, Value d) {
        return new ListValue(ListType.of(a.getType()), a, b, c, d);
    }

    public static ListValue of(Value a, Value b, Value c, Value d, Value e) {
        return new ListValue(ListType.of(a.getType()), a, b, c, d, e);
    }

    public int size() {
        return this.items.length;
    }

    public boolean isEmpty() {
        return this.items.length == 0;
    }

    public Value get(int index) {
        return this.items[index];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListValue that = (ListValue)o;
        return Arrays.equals(this.items, that.items);
    }

    public int hashCode() {
        return 31 * Type.Kind.LIST.hashCode() + Arrays.hashCode(this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("List[");
        for (Value item : this.items) {
            sb.append(item).append(", ");
        }
        if (this.items.length > 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public ListType getType() {
        return this.type;
    }

    @Override
    public ValueProtos.Value toPb() {
        if (this.isEmpty()) {
            return ProtoValue.list();
        }
        ValueProtos.Value.Builder builder = ValueProtos.Value.newBuilder();
        for (Value item : this.items) {
            builder.addItems(item.toPb());
        }
        return builder.build();
    }
}

