/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.description;

import com.google.common.collect.ImmutableList;
import com.yandex.ydb.table.description.ColumnFamily;
import com.yandex.ydb.table.description.KeyRange;
import com.yandex.ydb.table.description.TableColumn;
import com.yandex.ydb.table.description.TableIndex;
import com.yandex.ydb.table.values.OptionalType;
import com.yandex.ydb.table.values.Type;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class TableDescription {
    private final List<String> primaryKeys;
    private final List<TableColumn> columns;
    private final List<TableIndex> indexes;
    @Nullable
    private final TableStats tableStats;
    private final List<ColumnFamily> columnFamilies;
    private final List<KeyRange> keyRanges;

    private TableDescription(List<String> primaryKeys, List<TableColumn> columns, List<TableIndex> indexes, TableStats tableStats, List<ColumnFamily> columnFamilies, List<KeyRange> keyRanges) {
        this.primaryKeys = primaryKeys;
        this.columns = columns;
        this.indexes = indexes;
        this.tableStats = tableStats;
        this.columnFamilies = columnFamilies;
        this.keyRanges = keyRanges;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public List<TableColumn> getColumns() {
        return this.columns;
    }

    public List<TableIndex> getIndexes() {
        return this.indexes;
    }

    @Nullable
    public TableStats getTableStats() {
        return this.tableStats;
    }

    public List<ColumnFamily> getColumnFamilies() {
        return this.columnFamilies;
    }

    public List<KeyRange> getKeyRanges() {
        return this.keyRanges;
    }

    public static class TableStats {
        @Nullable
        private final Instant creationTime;
        @Nullable
        private final Instant modificationTime;
        private final long rowsEstimate;
        private final long storeSize;

        public TableStats(@Nullable Instant creationTime, @Nullable Instant modificationTime, long rowsEstimate, long storeSize) {
            this.creationTime = creationTime;
            this.modificationTime = modificationTime;
            this.rowsEstimate = rowsEstimate;
            this.storeSize = storeSize;
        }

        @Nullable
        public Instant getCreationTime() {
            return this.creationTime;
        }

        @Nullable
        public Instant getModificationTime() {
            return this.modificationTime;
        }

        public long getRowsEstimate() {
            return this.rowsEstimate;
        }

        public long getStoreSize() {
            return this.storeSize;
        }
    }

    public static class Builder {
        private List<String> primaryKeys = Collections.emptyList();
        private LinkedHashMap<String, TypeAndFamily> columns = new LinkedHashMap();
        private List<TableIndex> indexes = Collections.emptyList();
        private TableStats tableStats;
        private List<ColumnFamily> families = Collections.emptyList();
        private List<KeyRange> keyRanges = Collections.emptyList();

        public Builder addNonnullColumn(String name, Type type) {
            return this.addNonnullColumn(name, type, null);
        }

        public Builder addNonnullColumn(String name, Type type, String family) {
            this.columns.put(name, new TypeAndFamily(type, family));
            return this;
        }

        public Builder addKeyRange(KeyRange value) {
            if (this.keyRanges.isEmpty()) {
                this.keyRanges = new ArrayList<KeyRange>();
            }
            this.keyRanges.add(value);
            return this;
        }

        public Builder addNullableColumn(String name, Type type) {
            return this.addNullableColumn(name, type, null);
        }

        public Builder addNullableColumn(String name, Type type, String family) {
            this.columns.put(name, new TypeAndFamily(OptionalType.of(type), family));
            return this;
        }

        public Builder setPrimaryKey(String name) {
            this.checkColumnKnown(name);
            this.primaryKeys = ImmutableList.of((Object)name);
            return this;
        }

        public Builder setPrimaryKeys(String ... names) {
            if (names.length == 1) {
                return this.setPrimaryKey(names[0]);
            }
            HashSet<String> primaryKeys = new HashSet<String>(names.length);
            for (String name : names) {
                this.checkColumnKnown(name);
                if (primaryKeys.add(name)) continue;
                throw new IllegalArgumentException("non unique primary column name: " + name);
            }
            this.primaryKeys = ImmutableList.copyOf((Object[])names);
            return this;
        }

        public Builder setPrimaryKeys(List<String> names) {
            if (names.size() == 1) {
                return this.setPrimaryKey(names.get(0));
            }
            HashSet<String> primaryKeys = new HashSet<String>(names.size());
            for (String name : names) {
                this.checkColumnKnown(name);
                if (primaryKeys.add(name)) continue;
                throw new IllegalArgumentException("non unique primary column name: " + name);
            }
            this.primaryKeys = ImmutableList.copyOf(names);
            return this;
        }

        public Builder addGlobalIndex(String name, List<String> columns) {
            if (this.indexes.isEmpty()) {
                this.indexes = new ArrayList<TableIndex>(1);
            }
            this.indexes.add(new TableIndex(name, columns, TableIndex.Type.GLOBAL));
            return this;
        }

        public Builder tableStats(TableStats tableStats) {
            this.tableStats = tableStats;
            return this;
        }

        public Builder addColumnFamily(ColumnFamily family) {
            if (this.families.isEmpty()) {
                this.families = new ArrayList<ColumnFamily>();
            }
            this.families.add(family);
            return this;
        }

        public TableDescription build() {
            if (this.columns.isEmpty()) {
                throw new IllegalStateException("cannot build table description with no columns");
            }
            int i = 0;
            Object[] columns = new TableColumn[this.columns.size()];
            for (Map.Entry<String, TypeAndFamily> e : this.columns.entrySet()) {
                columns[i++] = new TableColumn(e.getKey(), e.getValue().type, e.getValue().family);
            }
            return new TableDescription(this.primaryKeys, (List)ImmutableList.copyOf((Object[])columns), (List)ImmutableList.copyOf(this.indexes), this.tableStats, this.families, this.keyRanges);
        }

        private void checkColumnKnown(String name) {
            if (!this.columns.containsKey(name)) {
                throw new IllegalArgumentException("unknown column name: " + name);
            }
        }

        private static class TypeAndFamily {
            private final Type type;
            private final String family;

            public TypeAndFamily(Type type, String family) {
                this.type = type;
                this.family = family;
            }
        }
    }
}

