/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.values;

import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.values.TupleType;
import com.yandex.ydb.table.values.Type;
import com.yandex.ydb.table.values.Value;
import com.yandex.ydb.table.values.proto.ProtoValue;
import java.util.Arrays;
import java.util.List;

public class TupleValue
implements Value<TupleType> {
    private static final TupleValue EMPTY = new TupleValue(TupleType.empty(), Value.EMPTY_ARRAY);
    private final TupleType type;
    private final Value[] items;

    TupleValue(TupleType type, Value ... items) {
        this.type = type;
        this.items = items;
    }

    public static TupleValue empty() {
        return EMPTY;
    }

    public static TupleValue of(Value item) {
        return new TupleValue(TupleType.of(item.getType()), item);
    }

    public static TupleValue of(Value a, Value b) {
        TupleType type = TupleType.ofOwn(new Type[]{a.getType(), b.getType()});
        return new TupleValue(type, a, b);
    }

    public static TupleValue of(Value a, Value b, Value c) {
        TupleType type = TupleType.ofOwn(new Type[]{a.getType(), b.getType(), c.getType()});
        return new TupleValue(type, a, b, c);
    }

    public static TupleValue of(Value a, Value b, Value c, Value d) {
        TupleType type = TupleType.ofOwn(new Type[]{a.getType(), b.getType(), c.getType(), d.getType()});
        return new TupleValue(type, a, b, c, d);
    }

    public static TupleValue of(Value a, Value b, Value c, Value d, Value e) {
        TupleType type = TupleType.ofOwn(new Type[]{a.getType(), b.getType(), c.getType(), d.getType(), e.getType()});
        return new TupleValue(type, a, b, c, d, e);
    }

    public static TupleValue of(List<Value> items) {
        if (items.isEmpty()) {
            return EMPTY;
        }
        return TupleValue.fromArray(items.toArray(Value.EMPTY_ARRAY));
    }

    public static TupleValue ofCopy(Value ... items) {
        if (items.length == 0) {
            return EMPTY;
        }
        return TupleValue.fromArray((Value[])items.clone());
    }

    public static TupleValue ofOwn(Value ... items) {
        if (items.length == 0) {
            return EMPTY;
        }
        return TupleValue.fromArray(items);
    }

    public int size() {
        return this.items.length;
    }

    public boolean isEmpty() {
        return this.items.length == 0;
    }

    public Value get(int index) {
        return this.items[index];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TupleValue that = (TupleValue)o;
        return Arrays.equals(this.items, that.items);
    }

    public int hashCode() {
        return 31 * Type.Kind.TUPLE.hashCode() + Arrays.hashCode(this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Tuple[");
        for (Value item : this.items) {
            sb.append(item).append(", ");
        }
        if (this.items.length > 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public TupleType getType() {
        return this.type;
    }

    @Override
    public ValueProtos.Value toPb() {
        if (this.isEmpty()) {
            return ProtoValue.tuple(new ValueProtos.Value[0]);
        }
        ValueProtos.Value.Builder builder = ValueProtos.Value.newBuilder();
        for (Value item : this.items) {
            builder.addItems(item.toPb());
        }
        return builder.build();
    }

    private static TupleValue fromArray(Value ... items) {
        int size = items.length;
        Type[] types = new Type[size];
        for (int i = 0; i < size; ++i) {
            types[i] = items[i].getType();
        }
        return new TupleValue(TupleType.ofOwn(types), items);
    }
}

