/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.description;

import com.google.common.collect.ImmutableList;
import com.yandex.ydb.table.description.ColumnFamily;
import com.yandex.ydb.table.description.KeyRange;
import com.yandex.ydb.table.description.TableColumn;
import com.yandex.ydb.table.description.TableIndex;
import com.yandex.ydb.table.settings.PartitioningSettings;
import com.yandex.ydb.table.values.OptionalType;
import com.yandex.ydb.table.values.Type;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class TableDescription {
    private final List<String> primaryKeys;
    private final List<TableColumn> columns;
    private final List<TableIndex> indexes;
    private final List<ColumnFamily> columnFamilies;
    private final List<KeyRange> keyRanges;
    @Nullable
    private final TableStats tableStats;
    @Nullable
    private final PartitioningSettings partitioningSettings;
    private final List<PartitionStats> partitionStats;

    private TableDescription(Builder builder) {
        this.primaryKeys = ImmutableList.copyOf((Collection)builder.primaryKeys);
        this.columns = builder.buildColumns();
        this.indexes = ImmutableList.copyOf((Collection)builder.indexes);
        this.columnFamilies = ImmutableList.copyOf((Collection)builder.families);
        this.keyRanges = ImmutableList.copyOf((Collection)builder.keyRanges);
        this.tableStats = builder.tableStats;
        this.partitioningSettings = builder.partitioningSettings;
        this.partitionStats = ImmutableList.copyOf((Collection)builder.partitionStats);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public List<TableColumn> getColumns() {
        return this.columns;
    }

    public List<TableIndex> getIndexes() {
        return this.indexes;
    }

    @Nullable
    public PartitioningSettings getPartitioningSettings() {
        return this.partitioningSettings;
    }

    @Nullable
    public TableStats getTableStats() {
        return this.tableStats;
    }

    public List<PartitionStats> getPartitionStats() {
        return this.partitionStats;
    }

    public List<ColumnFamily> getColumnFamilies() {
        return this.columnFamilies;
    }

    public List<KeyRange> getKeyRanges() {
        return this.keyRanges;
    }

    public static class TableStats {
        @Nullable
        private final Instant creationTime;
        @Nullable
        private final Instant modificationTime;
        private final long rowsEstimate;
        private final long storeSize;

        public TableStats(@Nullable Instant creationTime, @Nullable Instant modificationTime, long rowsEstimate, long storeSize) {
            this.creationTime = creationTime;
            this.modificationTime = modificationTime;
            this.rowsEstimate = rowsEstimate;
            this.storeSize = storeSize;
        }

        @Nullable
        public Instant getCreationTime() {
            return this.creationTime;
        }

        @Nullable
        public Instant getModificationTime() {
            return this.modificationTime;
        }

        public long getRowsEstimate() {
            return this.rowsEstimate;
        }

        public long getStoreSize() {
            return this.storeSize;
        }
    }

    public static class PartitionStats {
        private final long rowsEstimate;
        private final long storeSize;

        public PartitionStats(long rowsEstimate, long storeSize) {
            this.rowsEstimate = rowsEstimate;
            this.storeSize = storeSize;
        }

        public long rowsEstimate() {
            return this.rowsEstimate;
        }

        public long storeSize() {
            return this.storeSize;
        }
    }

    public static class Builder {
        private List<String> primaryKeys = Collections.emptyList();
        private final LinkedHashMap<String, TypeAndFamily> columns = new LinkedHashMap();
        private final List<TableIndex> indexes = new ArrayList<TableIndex>();
        private final List<ColumnFamily> families = new ArrayList<ColumnFamily>();
        private final List<KeyRange> keyRanges = new ArrayList<KeyRange>();
        private TableStats tableStats = null;
        private PartitioningSettings partitioningSettings = null;
        private final List<PartitionStats> partitionStats = new ArrayList<PartitionStats>();

        public Builder addNonnullColumn(String name, Type type) {
            return this.addNonnullColumn(name, type, null);
        }

        public Builder addNonnullColumn(String name, Type type, String family) {
            this.columns.put(name, new TypeAndFamily(type, family));
            return this;
        }

        public Builder addKeyRange(KeyRange value) {
            this.keyRanges.add(value);
            return this;
        }

        public Builder addNullableColumn(String name, Type type) {
            return this.addNullableColumn(name, type, null);
        }

        public Builder addNullableColumn(String name, Type type, String family) {
            this.columns.put(name, new TypeAndFamily(OptionalType.of(type), family));
            return this;
        }

        public Builder setPrimaryKey(String name) {
            this.checkColumnKnown(name);
            this.primaryKeys = ImmutableList.of((Object)name);
            return this;
        }

        public Builder setPrimaryKeys(String ... names) {
            if (names.length == 1) {
                return this.setPrimaryKey(names[0]);
            }
            HashSet<String> keys = new HashSet<String>(names.length);
            for (String name : names) {
                this.checkColumnKnown(name);
                if (keys.add(name)) continue;
                throw new IllegalArgumentException("non unique primary column name: " + name);
            }
            this.primaryKeys = ImmutableList.copyOf((Object[])names);
            return this;
        }

        public Builder setPrimaryKeys(List<String> names) {
            if (names.size() == 1) {
                return this.setPrimaryKey(names.get(0));
            }
            HashSet<String> keys = new HashSet<String>(names.size());
            for (String name : names) {
                this.checkColumnKnown(name);
                if (keys.add(name)) continue;
                throw new IllegalArgumentException("non unique primary column name: " + name);
            }
            this.primaryKeys = ImmutableList.copyOf(names);
            return this;
        }

        public Builder addGlobalIndex(String name, List<String> columns) {
            this.indexes.add(new TableIndex(name, columns, TableIndex.Type.GLOBAL));
            return this;
        }

        public Builder setTableStats(TableStats tableStats) {
            this.tableStats = tableStats;
            return this;
        }

        public Builder setPartitioningSettings(PartitioningSettings partitioningSettings) {
            this.partitioningSettings = partitioningSettings;
            return this;
        }

        public Builder addColumnFamily(ColumnFamily family) {
            this.families.add(family);
            return this;
        }

        public Builder addPartitionStat(long rows, long size) {
            this.partitionStats.add(new PartitionStats(rows, size));
            return this;
        }

        private List<TableColumn> buildColumns() {
            if (this.columns.isEmpty()) {
                throw new IllegalStateException("cannot build table description with no columns");
            }
            int i = 0;
            Object[] array = new TableColumn[this.columns.size()];
            for (Map.Entry<String, TypeAndFamily> e : this.columns.entrySet()) {
                array[i++] = new TableColumn(e.getKey(), e.getValue().type, e.getValue().family);
            }
            return ImmutableList.copyOf((Object[])array);
        }

        public TableDescription build() {
            return new TableDescription(this);
        }

        private void checkColumnKnown(String name) {
            if (!this.columns.containsKey(name)) {
                throw new IllegalArgumentException("unknown column name: " + name);
            }
        }

        private static class TypeAndFamily {
            private final Type type;
            private final String family;

            public TypeAndFamily(Type type, String family) {
                this.type = type;
                this.family = family;
            }
        }
    }
}

