/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.result.impl;

import com.google.protobuf.ByteString;
import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.result.ValueReader;
import com.yandex.ydb.table.result.impl.AbstractValueReader;
import com.yandex.ydb.table.utils.Hex;
import com.yandex.ydb.table.values.DecimalValue;
import com.yandex.ydb.table.values.Type;
import com.yandex.ydb.table.values.proto.ProtoType;
import com.yandex.ydb.table.values.proto.ProtoValue;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.UUID;

class ProtoPrimitiveValueReader
extends AbstractValueReader {
    private final ValueProtos.Type type;
    private final ValueProtos.Type.PrimitiveTypeId primitiveTypeId;
    private ValueProtos.Value value;

    ProtoPrimitiveValueReader(ValueProtos.Type type) {
        this.type = type;
        this.primitiveTypeId = type.getTypeId();
    }

    @Override
    protected ValueProtos.Type getProtoType() {
        return this.type;
    }

    @Override
    protected ValueProtos.Value getProtoValue() {
        return this.value;
    }

    @Override
    protected void setProtoValue(ValueProtos.Value value) {
        this.value = value;
    }

    @Override
    public boolean getBool() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.BOOL);
        return ProtoValue.toBool(this.value);
    }

    @Override
    public byte getInt8() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.INT8);
        return ProtoValue.toInt8(this.value);
    }

    @Override
    public int getUint8() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.UINT8);
        return ProtoValue.toUint8(this.value);
    }

    @Override
    public short getInt16() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.INT16);
        return ProtoValue.toInt16(this.value);
    }

    @Override
    public int getUint16() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.UINT16);
        return ProtoValue.toUint16(this.value);
    }

    @Override
    public int getInt32() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.INT32);
        return ProtoValue.toInt32(this.value);
    }

    @Override
    public long getUint32() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.UINT32);
        return ProtoValue.toUint32(this.value);
    }

    @Override
    public long getInt64() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.INT64);
        return ProtoValue.toInt64(this.value);
    }

    @Override
    public long getUint64() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.UINT64);
        return ProtoValue.toUint64(this.value);
    }

    @Override
    public float getFloat32() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.FLOAT);
        return ProtoValue.toFloat32(this.value);
    }

    @Override
    public double getFloat64() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.DOUBLE);
        return ProtoValue.toFloat64(this.value);
    }

    @Override
    public LocalDate getDate() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.DATE);
        return ProtoValue.toDate(this.value);
    }

    @Override
    public LocalDateTime getDatetime() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.DATETIME);
        return ProtoValue.toDatetime(this.value);
    }

    @Override
    public Instant getTimestamp() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.TIMESTAMP);
        return ProtoValue.toTimestamp(this.value);
    }

    @Override
    public Duration getInterval() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.INTERVAL);
        return ProtoValue.toInterval(this.value);
    }

    @Override
    public ZonedDateTime getTzDate() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.TZ_DATE);
        return ProtoValue.toTzDate(this.value);
    }

    @Override
    public ZonedDateTime getTzDatetime() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.TZ_DATETIME);
        return ProtoValue.toTzDatetime(this.value);
    }

    @Override
    public ZonedDateTime getTzTimestamp() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.TZ_TIMESTAMP);
        return ProtoValue.toTzTimestamp(this.value);
    }

    @Override
    public byte[] getString() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.STRING);
        return ProtoValue.toString(this.value);
    }

    @Override
    public String getString(Charset charset) {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.STRING);
        return ProtoValue.toString(this.value, charset);
    }

    @Override
    public UUID getUuid() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.UUID);
        return ProtoValue.toUuid(this.value);
    }

    @Override
    public String getUtf8() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.UTF8);
        return ProtoValue.toUtf8(this.value);
    }

    @Override
    public byte[] getYson() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.YSON);
        return ProtoValue.toYson(this.value);
    }

    @Override
    public String getJson() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.JSON);
        return ProtoValue.toJson(this.value);
    }

    @Override
    public String getJsonDocument() {
        this.checkPrimitive(ValueProtos.Type.PrimitiveTypeId.JSON_DOCUMENT);
        return ProtoValue.toJsonDocument(this.value);
    }

    @Override
    public DecimalValue getDecimal() {
        if (this.type.getTypeCase() != ValueProtos.Type.TypeCase.DECIMAL_TYPE) {
            throw new IllegalStateException("types mismatch, expected Decimal, but was " + ProtoType.toString(this.getProtoType()));
        }
        return ProtoValue.toDecimal(this.type, this.value);
    }

    private void checkPrimitive(ValueProtos.Type.PrimitiveTypeId expected) {
        if (this.primitiveTypeId != expected) {
            throw new IllegalStateException("types mismatch, expected " + expected + ", but was " + ProtoType.toString(this.getProtoType()));
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        block0 : switch (this.type.getTypeCase()) {
            case TYPE_ID: {
                switch (this.value.getValueCase()) {
                    case BOOL_VALUE: {
                        sb.append(this.value.getBoolValue());
                        break block0;
                    }
                    case INT32_VALUE: {
                        sb.append(this.value.getInt32Value());
                        break block0;
                    }
                    case UINT32_VALUE: {
                        sb.append(this.value.getUint32Value());
                        break block0;
                    }
                    case INT64_VALUE: {
                        sb.append(this.value.getInt64Value());
                        break block0;
                    }
                    case UINT64_VALUE: {
                        sb.append(this.value.getUint64Value());
                        break block0;
                    }
                    case FLOAT_VALUE: {
                        sb.append(this.value.getFloatValue());
                        break block0;
                    }
                    case DOUBLE_VALUE: {
                        sb.append(this.value.getDoubleValue());
                        break block0;
                    }
                    case BYTES_VALUE: {
                        ByteString bytes = this.value.getBytesValue();
                        if (bytes.isValidUtf8()) {
                            sb.append('\"');
                            sb.append(bytes.toStringUtf8());
                            sb.append('\"');
                            break block0;
                        }
                        Hex.toHex(bytes, sb);
                        break block0;
                    }
                    case TEXT_VALUE: {
                        sb.append('\"');
                        sb.append(this.value.getTextValue());
                        sb.append('\"');
                        break block0;
                    }
                }
                throw new IllegalStateException("unsupported value case: " + this.value.getValueCase());
            }
            case DECIMAL_TYPE: {
                this.getDecimal().toString(sb);
                break;
            }
            default: {
                throw new IllegalStateException("unsupported type case: " + this.type.getTypeCase());
            }
        }
    }

    static final class Optional
    extends ProtoPrimitiveValueReader {
        private final ValueProtos.Type optionalType;
        private boolean present = false;

        Optional(ValueProtos.Type type) {
            super(type.getOptionalType().getItem());
            this.optionalType = type;
        }

        @Override
        public Type getType() {
            return ProtoType.fromPb(this.optionalType);
        }

        @Override
        public boolean isOptionalItemPresent() {
            return this.present;
        }

        @Override
        public ValueReader getOptionalItem() {
            return this;
        }

        @Override
        protected void setProtoValue(ValueProtos.Value value) {
            if (value.getValueCase() == ValueProtos.Value.ValueCase.NULL_FLAG_VALUE) {
                this.present = false;
                value = ValueProtos.Value.getDefaultInstance();
            } else {
                this.present = true;
            }
            super.setProtoValue(value);
        }

        @Override
        public void toString(StringBuilder sb) {
            if (this.present) {
                sb.append("Some[");
                super.toString(sb);
                sb.append(']');
            } else {
                sb.append("Empty[]");
            }
        }
    }
}

