/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.values;

import com.google.common.base.Preconditions;
import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.values.DecimalValue;
import com.yandex.ydb.table.values.Type;
import com.yandex.ydb.table.values.proto.ProtoType;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DecimalType
implements Type {
    public static final int MAX_PRECISION = 35;
    private static final DecimalType DEFAULT_TYPE = DecimalType.of(35);
    private final byte precision;
    private final byte scale;

    private DecimalType(byte precision, byte scale) {
        this.precision = precision;
        this.scale = scale;
    }

    public static DecimalType of() {
        return DEFAULT_TYPE;
    }

    public static DecimalType of(int precision) {
        return DecimalType.of(precision, 0);
    }

    public static DecimalType of(int precision, int scale) {
        Preconditions.checkArgument((precision >= 1 && precision <= 35 ? 1 : 0) != 0, (String)"precision (%s) is out of range [1, %s]", (int)precision, (int)35);
        Preconditions.checkArgument((scale >= 0 && scale <= precision ? 1 : 0) != 0, (String)"scale (%s) is out of range [0, %s]", (int)scale, (int)precision);
        return new DecimalType((byte)precision, (byte)scale);
    }

    @Override
    public Type.Kind getKind() {
        return Type.Kind.DECIMAL;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecimalType that = (DecimalType)o;
        if (this.precision != that.precision) {
            return false;
        }
        return this.scale == that.scale;
    }

    @Override
    public int hashCode() {
        return 31 * this.precision + this.scale;
    }

    @Override
    public String toString() {
        return "Decimal(" + this.precision + ", " + this.scale + ')';
    }

    @Override
    public ValueProtos.Type toPb() {
        return ProtoType.decimal(this.precision, this.scale);
    }

    private DecimalValue toZero() {
        return this.precision == 35 && this.scale == 0 ? DecimalValue.ZERO : new DecimalValue(this, 0L, 0L);
    }

    public DecimalValue newValue(long high, long low) {
        if (high == 0L && low == 0L) {
            return this.toZero();
        }
        DecimalValue nan = DecimalValue.NAN;
        if (nan.getHigh() == high && nan.getLow() == low) {
            return nan;
        }
        DecimalValue inf = DecimalValue.INF;
        if (high > inf.getHigh() || high == inf.getHigh() && Long.compareUnsigned(low, inf.getLow()) >= 0) {
            return inf;
        }
        DecimalValue negInf = DecimalValue.NEG_INF;
        if (high < negInf.getHigh() || high == negInf.getHigh() && Long.compareUnsigned(low, negInf.getLow()) <= 0) {
            return negInf;
        }
        return new DecimalValue(this, high, low);
    }

    public DecimalValue newValue(long value) {
        if (value == 0L) {
            return this.toZero();
        }
        long high = value > 0L ? 0L : -1L;
        return new DecimalValue(this, high, value);
    }

    public DecimalValue newValueUnsigned(long value) {
        if (value == 0L) {
            return this.toZero();
        }
        return new DecimalValue(this, 0L, value);
    }

    public DecimalValue newValue(BigInteger value) {
        boolean negative;
        int bitLength = value.bitLength();
        if (bitLength < 64) {
            return this.newValue(value.longValue());
        }
        boolean bl = negative = value.signum() < 0;
        if (bitLength > 128) {
            return negative ? DecimalValue.NEG_INF : DecimalValue.INF;
        }
        byte[] buf = value.abs().toByteArray();
        long high = DecimalType.getLongBe(buf, 0, buf.length - 8);
        long low = DecimalType.getLongBe(buf, buf.length - 8, buf.length);
        if (negative && (high != Long.MIN_VALUE || low != 0L)) {
            high ^= 0xFFFFFFFFFFFFFFFFL;
            low ^= 0xFFFFFFFFFFFFFFFFL;
            if (++low == 0L) {
                ++high;
            }
        }
        return this.newValue(high, low);
    }

    public DecimalValue newValue(BigDecimal value) {
        return this.newValue(value.unscaledValue());
    }

    public DecimalValue newValue(String value) {
        int scaleAdjust;
        if (value.isEmpty()) {
            throw new NumberFormatException("cannot parse decimal from empty string");
        }
        int end = value.length();
        int cursor = 0;
        boolean negative = false;
        if (value.charAt(cursor) == '+') {
            ++cursor;
        } else if (value.charAt(cursor) == '-') {
            ++cursor;
            negative = true;
        }
        if (end - cursor == 3) {
            char c1 = value.charAt(cursor);
            char c2 = value.charAt(cursor + 1);
            char c3 = value.charAt(cursor + 2);
            if ((c1 == 'i' || c1 == 'I') && (c2 == 'n' || c2 == 'N') || c3 == 'f' || c3 == 'F') {
                return negative ? DecimalValue.NEG_INF : DecimalValue.INF;
            }
            if ((c1 == 'n' || c1 == 'N') && (c2 == 'a' || c2 == 'A') || c3 == 'n' || c3 == 'N') {
                return DecimalValue.NAN;
            }
        }
        while (cursor < end && value.charAt(cursor) == '0') {
            ++cursor;
        }
        if (cursor == end) {
            return this.toZero();
        }
        long accumulated = 0L;
        int accumulatedCount = 0;
        boolean fractional = false;
        int fractionalDigits = 0;
        BigInteger unscaledValue = BigInteger.ZERO;
        while (cursor < end) {
            char ch = value.charAt(cursor);
            if (ch >= '0' && ch <= '9') {
                if ((long)accumulatedCount == 18L) {
                    if (unscaledValue == BigInteger.ZERO) {
                        unscaledValue = BigInteger.valueOf(accumulated);
                    } else {
                        unscaledValue = unscaledValue.multiply(BigInteger.TEN.pow(accumulatedCount));
                        unscaledValue = unscaledValue.add(BigInteger.valueOf(accumulated));
                    }
                    accumulated = 0L;
                    accumulatedCount = 0;
                }
                int digit = ch - 48;
                accumulated = accumulated * 10L + (long)digit;
                ++accumulatedCount;
                if (fractional) {
                    ++fractionalDigits;
                }
            } else if (ch == '.') {
                if (fractional) {
                    throw new NumberFormatException("invalid string: " + value);
                }
                fractional = true;
            } else {
                throw new NumberFormatException("invalid string: " + value);
            }
            ++cursor;
        }
        if (accumulatedCount > 0) {
            if (unscaledValue == BigInteger.ZERO) {
                unscaledValue = BigInteger.valueOf(accumulated);
            } else {
                unscaledValue = unscaledValue.multiply(BigInteger.TEN.pow(accumulatedCount));
                unscaledValue = unscaledValue.add(BigInteger.valueOf(accumulated));
            }
        }
        if ((scaleAdjust = this.getScale() - fractionalDigits) > 0) {
            unscaledValue = unscaledValue.multiply(BigInteger.TEN.pow(scaleAdjust));
        } else if (scaleAdjust < 0) {
            unscaledValue = unscaledValue.divide(BigInteger.TEN.pow(-scaleAdjust));
        }
        if (negative) {
            unscaledValue = unscaledValue.negate();
        }
        return this.newValue(unscaledValue);
    }

    private static long getLongBe(byte[] buf, int from, int to) {
        long r = 0L;
        for (int i = from; i < to; ++i) {
            r = r << 8 | (long)(buf[i] & 0xFF);
        }
        return r;
    }
}

