/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.query;

import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.common.CommonProtos;
import com.yandex.ydb.table.result.ResultSetReader;
import com.yandex.ydb.table.result.impl.ProtoValueReaders;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataQueryResult {
    private final String txId;
    private final List<ValueProtos.ResultSet> resultSets;
    @Nullable
    private final CostInfo costInfo;

    public DataQueryResult(String txId, List<ValueProtos.ResultSet> resultSets) {
        this(txId, resultSets, null);
    }

    public DataQueryResult(String txId, List<ValueProtos.ResultSet> resultSets, @Nullable CostInfo costInfo) {
        this.txId = txId;
        this.resultSets = resultSets;
        this.costInfo = costInfo;
    }

    public String getTxId() {
        return this.txId;
    }

    public int getResultSetCount() {
        return this.resultSets.size();
    }

    public ResultSetReader getResultSet(int index) {
        return ProtoValueReaders.forResultSet(this.resultSets.get(index));
    }

    public boolean isTruncated(int index) {
        return this.resultSets.get(index).getTruncated();
    }

    public int getRowCount(int index) {
        return this.resultSets.get(index).getRowsCount();
    }

    public boolean isEmpty() {
        return this.txId.isEmpty() && this.resultSets.isEmpty();
    }

    @Nullable
    public CostInfo getCostInfo() {
        return this.costInfo;
    }

    public static class CostInfo {
        private final double consumedUnits;

        public CostInfo(@Nonnull CommonProtos.CostInfo costInfo) {
            this.consumedUnits = costInfo.getConsumedUnits();
        }

        public double getConsumedUnits() {
            return this.consumedUnits;
        }
    }
}

