/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.impl;

import com.google.protobuf.Timestamp;
import com.yandex.ydb.OperationProtos;
import com.yandex.ydb.StatusCodesProtos;
import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.common.CommonProtos;
import com.yandex.ydb.core.Issue;
import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.Status;
import com.yandex.ydb.core.StatusCode;
import com.yandex.ydb.core.grpc.EndpointInfo;
import com.yandex.ydb.core.grpc.GrpcRequestSettings;
import com.yandex.ydb.core.grpc.YdbHeaders;
import com.yandex.ydb.core.rpc.OperationTray;
import com.yandex.ydb.core.rpc.StreamControl;
import com.yandex.ydb.core.rpc.StreamObserver;
import com.yandex.ydb.table.Session;
import com.yandex.ydb.table.SessionStatus;
import com.yandex.ydb.table.YdbTable;
import com.yandex.ydb.table.description.ColumnFamily;
import com.yandex.ydb.table.description.KeyBound;
import com.yandex.ydb.table.description.KeyRange;
import com.yandex.ydb.table.description.StoragePool;
import com.yandex.ydb.table.description.TableColumn;
import com.yandex.ydb.table.description.TableDescription;
import com.yandex.ydb.table.description.TableIndex;
import com.yandex.ydb.table.impl.DataQueryImpl;
import com.yandex.ydb.table.impl.QueryCache;
import com.yandex.ydb.table.impl.SessionPool;
import com.yandex.ydb.table.impl.TransactionImpl;
import com.yandex.ydb.table.query.DataQuery;
import com.yandex.ydb.table.query.DataQueryResult;
import com.yandex.ydb.table.query.ExplainDataQueryResult;
import com.yandex.ydb.table.query.Params;
import com.yandex.ydb.table.result.ReadTableMeta;
import com.yandex.ydb.table.result.ResultSetReader;
import com.yandex.ydb.table.result.impl.ProtoValueReaders;
import com.yandex.ydb.table.rpc.TableRpc;
import com.yandex.ydb.table.settings.AlterTableSettings;
import com.yandex.ydb.table.settings.AutoPartitioningPolicy;
import com.yandex.ydb.table.settings.BeginTxSettings;
import com.yandex.ydb.table.settings.BulkUpsertSettings;
import com.yandex.ydb.table.settings.CloseSessionSettings;
import com.yandex.ydb.table.settings.CommitTxSettings;
import com.yandex.ydb.table.settings.CopyTableSettings;
import com.yandex.ydb.table.settings.CreateTableSettings;
import com.yandex.ydb.table.settings.DescribeTableSettings;
import com.yandex.ydb.table.settings.DropTableSettings;
import com.yandex.ydb.table.settings.ExecuteDataQuerySettings;
import com.yandex.ydb.table.settings.ExecuteScanQuerySettings;
import com.yandex.ydb.table.settings.ExecuteSchemeQuerySettings;
import com.yandex.ydb.table.settings.ExplainDataQuerySettings;
import com.yandex.ydb.table.settings.KeepAliveSessionSettings;
import com.yandex.ydb.table.settings.PartitioningPolicy;
import com.yandex.ydb.table.settings.PartitioningSettings;
import com.yandex.ydb.table.settings.PrepareDataQuerySettings;
import com.yandex.ydb.table.settings.ReadTableSettings;
import com.yandex.ydb.table.settings.ReplicationPolicy;
import com.yandex.ydb.table.settings.RequestSettings;
import com.yandex.ydb.table.settings.RollbackTxSettings;
import com.yandex.ydb.table.settings.StoragePolicy;
import com.yandex.ydb.table.settings.TtlSettings;
import com.yandex.ydb.table.transaction.Transaction;
import com.yandex.ydb.table.transaction.TransactionMode;
import com.yandex.ydb.table.transaction.TxControl;
import com.yandex.ydb.table.utils.OperationParamUtils;
import com.yandex.ydb.table.utils.RequestSettingsUtils;
import com.yandex.ydb.table.values.ListValue;
import com.yandex.ydb.table.values.TupleValue;
import com.yandex.ydb.table.values.Value;
import com.yandex.ydb.table.values.proto.ProtoType;
import com.yandex.ydb.table.values.proto.ProtoValue;
import io.grpc.Metadata;
import java.net.URI;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionImpl
implements Session {
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    private static final AtomicReferenceFieldUpdater<SessionImpl, State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(SessionImpl.class, State.class, "state");
    private final String id;
    private final EndpointInfo endpoint;
    private final TableRpc tableRpc;
    private final OperationTray operationTray;
    private final ShutdownHandler shutdownHandler;
    @Nullable
    private final SessionPool sessionPool;
    @Nullable
    private final QueryCache queryCache;
    private final boolean keepQueryText;
    private volatile State state = State.ACTIVE;

    SessionImpl(String id, TableRpc tableRpc, SessionPool sessionPool, int queryCacheSize, boolean keepQueryText) {
        this.id = id;
        this.tableRpc = tableRpc;
        this.operationTray = tableRpc.getOperationTray();
        this.sessionPool = sessionPool;
        this.queryCache = queryCacheSize > 0 ? new QueryCache(queryCacheSize) : null;
        this.keepQueryText = keepQueryText;
        Integer nodeId = SessionImpl.getNodeIdFromSessionId(id);
        this.endpoint = nodeId == null ? null : new EndpointInfo(nodeId.intValue(), tableRpc.getEndpointByNodeId(nodeId));
        this.shutdownHandler = new ShutdownHandler();
    }

    @Nullable
    private static Integer getNodeIdFromSessionId(String sessionId) {
        try {
            URI uri = new URI(sessionId);
            Map<String, String> params = SessionImpl.getQueryMap(uri.getQuery());
            if (params == null) {
                return null;
            }
            String nodeStr = params.get("node_id");
            if (nodeStr == null) {
                return null;
            }
            return Integer.parseUnsignedInt(nodeStr);
        }
        catch (Exception e) {
            log.debug("Failed to parse session_id for node_id: {}", (Object)e.toString());
            return null;
        }
    }

    private static Map<String, String> getQueryMap(String query) {
        if (query == null) {
            return null;
        }
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }

    private GrpcRequestSettings makeGrpcRequestSettings(RequestSettings<?> settings) {
        return GrpcRequestSettings.newBuilder().withDeadlineAfter(RequestSettingsUtils.calculateDeadlineAfter(settings)).withPreferredEndpoint(this.endpoint).withTrailersHandler((Consumer)this.shutdownHandler).build();
    }

    @Override
    public String getId() {
        return this.id;
    }

    State getState() {
        return stateUpdater.get(this);
    }

    void setState(State state) {
        stateUpdater.set(this, state);
    }

    boolean switchState(State from, State to) {
        return stateUpdater.compareAndSet(this, from, to);
    }

    boolean isGracefulShutdown() {
        return this.shutdownHandler.isGracefulShutdown();
    }

    private static void applyPartitioningSettings(PartitioningSettings partitioningSettings, Consumer<YdbTable.PartitioningSettings> consumer) {
        if (partitioningSettings == null) {
            return;
        }
        YdbTable.PartitioningSettings.Builder builder = YdbTable.PartitioningSettings.newBuilder();
        if (partitioningSettings.getPartitioningByLoad() != null) {
            builder.setPartitioningByLoad(partitioningSettings.getPartitioningByLoad() != false ? CommonProtos.FeatureFlag.Status.ENABLED : CommonProtos.FeatureFlag.Status.DISABLED);
        }
        if (partitioningSettings.getPartitioningBySize() != null) {
            builder.setPartitioningBySize(partitioningSettings.getPartitioningBySize() != false ? CommonProtos.FeatureFlag.Status.ENABLED : CommonProtos.FeatureFlag.Status.DISABLED);
        }
        if (partitioningSettings.getPartitionSizeMb() != null) {
            builder.setPartitionSizeMb(partitioningSettings.getPartitionSizeMb().longValue());
        }
        if (partitioningSettings.getMinPartitionsCount() != null) {
            builder.setMinPartitionsCount(partitioningSettings.getMinPartitionsCount().longValue());
        }
        if (partitioningSettings.getMaxPartitionsCount() != null) {
            builder.setMaxPartitionsCount(partitioningSettings.getMaxPartitionsCount().longValue());
        }
        consumer.accept(builder.build());
    }

    @Override
    public CompletableFuture<Status> createTable(String path, TableDescription tableDescription, CreateTableSettings settings) {
        TtlSettings ttlSettings;
        YdbTable.PartitioningPolicy.Builder policyProto;
        Object policy;
        YdbTable.CreateTableRequest.Builder request = YdbTable.CreateTableRequest.newBuilder().setSessionId(this.id).setPath(path).setOperationParams(OperationParamUtils.fromRequestSettings(settings)).addAllPrimaryKey(tableDescription.getPrimaryKeys());
        PartitioningSettings partitioningSettings = tableDescription.getPartitioningSettings();
        if (partitioningSettings == null) {
            partitioningSettings = settings.getPartitioningSettings();
        }
        SessionImpl.applyPartitioningSettings(partitioningSettings, arg_0 -> ((YdbTable.CreateTableRequest.Builder)request).setPartitioningSettings(arg_0));
        for (TableColumn column : tableDescription.getColumns()) {
            YdbTable.ColumnMeta.Builder builder = YdbTable.ColumnMeta.newBuilder().setName(column.getName()).setType(column.getType().toPb());
            if (column.getFamily() != null) {
                builder.setFamily(column.getFamily());
            }
            request.addColumns(builder.build());
        }
        for (TableIndex index : tableDescription.getIndexes()) {
            YdbTable.TableIndex.Builder b = request.addIndexesBuilder();
            b.setName(index.getName());
            b.addAllIndexColumns(index.getColumns());
            if (index.getType() != TableIndex.Type.GLOBAL) continue;
            b.setGlobalIndex(YdbTable.GlobalIndex.getDefaultInstance());
        }
        for (ColumnFamily family : tableDescription.getColumnFamilies()) {
            YdbTable.ColumnFamily.Compression compression;
            switch (family.getCompression()) {
                case COMPRESSION_NONE: {
                    compression = YdbTable.ColumnFamily.Compression.COMPRESSION_NONE;
                    break;
                }
                case COMPRESSION_LZ4: {
                    compression = YdbTable.ColumnFamily.Compression.COMPRESSION_LZ4;
                    break;
                }
                default: {
                    compression = YdbTable.ColumnFamily.Compression.COMPRESSION_UNSPECIFIED;
                }
            }
            request.addColumnFamilies(YdbTable.ColumnFamily.newBuilder().setKeepInMemoryValue(family.isKeepInMemory() ? CommonProtos.FeatureFlag.Status.ENABLED.getNumber() : CommonProtos.FeatureFlag.Status.DISABLED.getNumber()).setCompression(compression).setData(YdbTable.StoragePool.newBuilder().setMedia(family.getData().getMedia())).setName(family.getName()).build());
        }
        if (settings.getPresetName() != null) {
            request.getProfileBuilder().setPresetName(settings.getPresetName());
        }
        if (settings.getExecutionPolicy() != null) {
            request.getProfileBuilder().getExecutionPolicyBuilder().setPresetName(settings.getExecutionPolicy());
        }
        if (settings.getCompactionPolicy() != null) {
            request.getProfileBuilder().getCompactionPolicyBuilder().setPresetName(settings.getCompactionPolicy());
        }
        if ((policy = settings.getPartitioningPolicy()) != null) {
            policyProto = request.getProfileBuilder().getPartitioningPolicyBuilder();
            if (((PartitioningPolicy)policy).getPresetName() != null) {
                policyProto.setPresetName(((PartitioningPolicy)policy).getPresetName());
            }
            if (((PartitioningPolicy)policy).getAutoPartitioning() != null) {
                policyProto.setAutoPartitioning(SessionImpl.toPb(((PartitioningPolicy)policy).getAutoPartitioning()));
            }
            if (((PartitioningPolicy)policy).getUniformPartitions() > 0L) {
                policyProto.setUniformPartitions(((PartitioningPolicy)policy).getUniformPartitions());
            } else {
                List<TupleValue> points = ((PartitioningPolicy)policy).getExplicitPartitioningPoints();
                if (points != null) {
                    YdbTable.ExplicitPartitions.Builder b = policyProto.getExplicitPartitionsBuilder();
                    for (Value value : points) {
                        b.addSplitPoints(ProtoValue.toTypedValue(value));
                    }
                }
            }
        }
        if ((policy = settings.getStoragePolicy()) != null) {
            policyProto = request.getProfileBuilder().getStoragePolicyBuilder();
            if (((StoragePolicy)policy).getPresetName() != null) {
                policyProto.setPresetName(((StoragePolicy)policy).getPresetName());
            }
            if (((StoragePolicy)policy).getSysLog() != null) {
                policyProto.getSyslogBuilder().setMedia(((StoragePolicy)policy).getSysLog());
            }
            if (((StoragePolicy)policy).getLog() != null) {
                policyProto.getLogBuilder().setMedia(((StoragePolicy)policy).getLog());
            }
            if (((StoragePolicy)policy).getData() != null) {
                policyProto.getDataBuilder().setMedia(((StoragePolicy)policy).getData());
            }
            if (((StoragePolicy)policy).getExternal() != null) {
                policyProto.getExternalBuilder().setMedia(((StoragePolicy)policy).getExternal());
            }
        }
        if ((policy = settings.getReplicationPolicy()) != null) {
            YdbTable.ReplicationPolicy.Builder replicationPolicyProto = request.getProfileBuilder().getReplicationPolicyBuilder();
            if (((ReplicationPolicy)policy).getPresetName() != null) {
                replicationPolicyProto.setPresetName(((ReplicationPolicy)policy).getPresetName());
            }
            replicationPolicyProto.setReplicasCount(((ReplicationPolicy)policy).getReplicasCount());
            replicationPolicyProto.setCreatePerAvailabilityZone(((ReplicationPolicy)policy).isCreatePerAvailabilityZone() ? CommonProtos.FeatureFlag.Status.ENABLED : CommonProtos.FeatureFlag.Status.DISABLED);
            replicationPolicyProto.setAllowPromotion(((ReplicationPolicy)policy).isAllowPromotion() ? CommonProtos.FeatureFlag.Status.ENABLED : CommonProtos.FeatureFlag.Status.DISABLED);
        }
        if ((ttlSettings = settings.getTtlSettings()) != null) {
            YdbTable.DateTypeColumnModeSettings.Builder dateTypeColumnBuilder = request.getTtlSettingsBuilder().getDateTypeColumnBuilder();
            dateTypeColumnBuilder.setColumnName(ttlSettings.getDateTimeColumn());
            dateTypeColumnBuilder.setExpireAfterSeconds(ttlSettings.getExpireAfterSeconds());
        }
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings(settings);
        return this.tableRpc.createTable(request.build(), grpcRequestSettings).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.CreateTableResponse)response.expect("createTable()")).getOperation(), grpcRequestSettings);
        });
    }

    private static YdbTable.PartitioningPolicy.AutoPartitioningPolicy toPb(AutoPartitioningPolicy policy) {
        switch (policy) {
            case AUTO_SPLIT: {
                return YdbTable.PartitioningPolicy.AutoPartitioningPolicy.AUTO_SPLIT;
            }
            case AUTO_SPLIT_MERGE: {
                return YdbTable.PartitioningPolicy.AutoPartitioningPolicy.AUTO_SPLIT_MERGE;
            }
            case DISABLED: {
                return YdbTable.PartitioningPolicy.AutoPartitioningPolicy.DISABLED;
            }
        }
        throw new IllegalArgumentException("unknown AutoPartitioningPolicy: " + (Object)((Object)policy));
    }

    @Override
    public CompletableFuture<Status> dropTable(String path, DropTableSettings settings) {
        YdbTable.DropTableRequest request = YdbTable.DropTableRequest.newBuilder().setSessionId(this.id).setPath(path).setOperationParams(OperationParamUtils.fromRequestSettings(settings)).build();
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings(settings);
        return this.tableRpc.dropTable(request, grpcRequestSettings).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.DropTableResponse)response.expect("dropTable()")).getOperation(), grpcRequestSettings);
        });
    }

    @Override
    public CompletableFuture<Status> alterTable(String path, AlterTableSettings settings) {
        YdbTable.AlterTableRequest.Builder builder = YdbTable.AlterTableRequest.newBuilder().setSessionId(this.id).setPath(path).setOperationParams(OperationParamUtils.fromRequestSettings(settings));
        settings.forEachAddColumn((name, type) -> builder.addAddColumns(YdbTable.ColumnMeta.newBuilder().setName(name).setType(type.toPb()).build()));
        settings.forEachDropColumn(arg_0 -> ((YdbTable.AlterTableRequest.Builder)builder).addDropColumns(arg_0));
        settings.forEachAddChangefeed(changefeed -> builder.addAddChangefeeds(changefeed.toProto()));
        settings.forEachDropChangefeed(arg_0 -> ((YdbTable.AlterTableRequest.Builder)builder).addDropChangefeeds(arg_0));
        TtlSettings ttlSettings = settings.getTtlSettings();
        if (ttlSettings != null) {
            YdbTable.DateTypeColumnModeSettings.Builder dateTypeColumnBuilder = builder.getSetTtlSettingsBuilder().getDateTypeColumnBuilder();
            dateTypeColumnBuilder.setColumnName(ttlSettings.getDateTimeColumn());
            dateTypeColumnBuilder.setExpireAfterSeconds(ttlSettings.getExpireAfterSeconds());
        }
        SessionImpl.applyPartitioningSettings(settings.getPartitioningSettings(), arg_0 -> ((YdbTable.AlterTableRequest.Builder)builder).setAlterPartitioningSettings(arg_0));
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings(settings);
        return this.tableRpc.alterTable(builder.build(), grpcRequestSettings).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.AlterTableResponse)response.expect("alterTable()")).getOperation(), grpcRequestSettings);
        });
    }

    @Override
    public CompletableFuture<Status> copyTable(String src, String dst, CopyTableSettings settings) {
        YdbTable.CopyTableRequest request = YdbTable.CopyTableRequest.newBuilder().setSessionId(this.id).setSourcePath(src).setDestinationPath(dst).setOperationParams(OperationParamUtils.fromRequestSettings(settings)).build();
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings(settings);
        return this.tableRpc.copyTable(request, grpcRequestSettings).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.CopyTableResponse)response.expect("copyTable()")).getOperation(), grpcRequestSettings);
        });
    }

    @Override
    public CompletableFuture<Result<TableDescription>> describeTable(String path, DescribeTableSettings settings) {
        YdbTable.DescribeTableRequest request = YdbTable.DescribeTableRequest.newBuilder().setSessionId(this.id).setPath(path).setOperationParams(OperationParamUtils.fromRequestSettings(settings)).setIncludeTableStats(settings.isIncludeTableStats()).setIncludeShardKeyBounds(settings.isIncludeShardKeyBounds()).setIncludePartitionStats(settings.isIncludePartitionStats()).build();
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings(settings);
        return this.tableRpc.describeTable(request, grpcRequestSettings).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.operationTray.waitResult(((YdbTable.DescribeTableResponse)response.expect("describeTable()")).getOperation(), YdbTable.DescribeTableResult.class, result -> SessionImpl.mapDescribeTable(result, settings), grpcRequestSettings);
        });
    }

    private static TableDescription mapDescribeTable(YdbTable.DescribeTableResult result, DescribeTableSettings describeTableSettings) {
        List shardKeyBoundsList;
        List columnFamiliesList;
        YdbTable.PartitioningSettings partitioningSettings;
        int i;
        TableDescription.Builder description = TableDescription.newBuilder();
        for (i = 0; i < result.getColumnsCount(); ++i) {
            YdbTable.ColumnMeta column = result.getColumns(i);
            description.addNonnullColumn(column.getName(), ProtoType.fromPb(column.getType()), column.getFamily());
        }
        description.setPrimaryKeys((List<String>)result.getPrimaryKeyList());
        for (i = 0; i < result.getIndexesCount(); ++i) {
            YdbTable.TableIndexDescription index = result.getIndexes(i);
            description.addGlobalIndex(index.getName(), (List<String>)index.getIndexColumnsList(), (List<String>)index.getDataColumnsList());
        }
        YdbTable.TableStats tableStats = result.getTableStats();
        if (describeTableSettings.isIncludeTableStats() && tableStats != null) {
            Timestamp creationTime = tableStats.getCreationTime();
            Instant createdAt = creationTime == null ? null : Instant.ofEpochSecond(creationTime.getSeconds(), creationTime.getNanos());
            Timestamp modificationTime = tableStats.getCreationTime();
            Instant modifiedAt = modificationTime == null ? null : Instant.ofEpochSecond(modificationTime.getSeconds(), modificationTime.getNanos());
            TableDescription.TableStats stats = new TableDescription.TableStats(createdAt, modifiedAt, tableStats.getRowsEstimate(), tableStats.getStoreSize());
            description.setTableStats(stats);
            List partitionStats = tableStats.getPartitionStatsList();
            if (describeTableSettings.isIncludePartitionStats() && partitionStats != null) {
                for (YdbTable.PartitionStats stat : partitionStats) {
                    description.addPartitionStat(stat.getRowsEstimate(), stat.getStoreSize());
                }
            }
        }
        if ((partitioningSettings = result.getPartitioningSettings()) != null) {
            PartitioningSettings settings = new PartitioningSettings();
            settings.setPartitionSize(partitioningSettings.getPartitionSizeMb());
            settings.setMinPartitionsCount(partitioningSettings.getMinPartitionsCount());
            settings.setMaxPartitionsCount(partitioningSettings.getMaxPartitionsCount());
            settings.setPartitioningByLoad(partitioningSettings.getPartitioningByLoad() == CommonProtos.FeatureFlag.Status.ENABLED);
            settings.setPartitioningBySize(partitioningSettings.getPartitioningBySize() == CommonProtos.FeatureFlag.Status.ENABLED);
            description.setPartitioningSettings(settings);
        }
        if ((columnFamiliesList = result.getColumnFamiliesList()) != null) {
            for (YdbTable.ColumnFamily family : columnFamiliesList) {
                ColumnFamily.Compression compression;
                switch (family.getCompression()) {
                    case COMPRESSION_LZ4: {
                        compression = ColumnFamily.Compression.COMPRESSION_LZ4;
                        break;
                    }
                    default: {
                        compression = ColumnFamily.Compression.COMPRESSION_NONE;
                    }
                }
                description.addColumnFamily(new ColumnFamily(family.getName(), new StoragePool(family.getData().getMedia()), compression, family.getKeepInMemory().equals((Object)CommonProtos.FeatureFlag.Status.ENABLED)));
            }
        }
        if (describeTableSettings.isIncludeShardKeyBounds() && (shardKeyBoundsList = result.getShardKeyBoundsList()) != null) {
            Optional<Value> leftValue = Optional.empty();
            for (ValueProtos.TypedValue typedValue : shardKeyBoundsList) {
                Optional<KeyBound> fromBound = leftValue.map(KeyBound::inclusive);
                Value value = ProtoValue.fromPb(ProtoType.fromPb(typedValue.getType()), typedValue.getValue());
                Optional<KeyBound> toBound = Optional.of(KeyBound.exclusive(value));
                description.addKeyRange(new KeyRange(fromBound, toBound));
                leftValue = Optional.of(value);
            }
            description.addKeyRange(new KeyRange(leftValue.map(KeyBound::inclusive), Optional.empty()));
        }
        return description.build();
    }

    private static YdbTable.TransactionSettings txSettings(TransactionMode transactionMode) {
        YdbTable.TransactionSettings.Builder settings = YdbTable.TransactionSettings.newBuilder();
        if (transactionMode != null) {
            switch (transactionMode) {
                case SERIALIZABLE_READ_WRITE: {
                    settings.setSerializableReadWrite(YdbTable.SerializableModeSettings.getDefaultInstance());
                    break;
                }
                case ONLINE_READ_ONLY: {
                    settings.setOnlineReadOnly(YdbTable.OnlineModeSettings.getDefaultInstance());
                    break;
                }
                case STALE_READ_ONLY: {
                    settings.setStaleReadOnly(YdbTable.StaleModeSettings.getDefaultInstance());
                    break;
                }
                case SNAPSHOT_READ_ONLY: {
                    settings.setSnapshotReadOnly(YdbTable.SnapshotModeSettings.getDefaultInstance());
                    break;
                }
            }
        }
        return settings.build();
    }

    @Override
    public CompletableFuture<Result<DataQueryResult>> executeDataQuery(String query, TxControl txControl, Params params, ExecuteDataQuerySettings settings) {
        boolean keepInClientQueryCache;
        DataQueryImpl dataQuery;
        if (this.queryCache != null && (dataQuery = this.queryCache.find(query)) != null) {
            return dataQuery.execute(txControl, params, settings).whenComplete((r, t) -> {
                if (r.getCode() == StatusCode.NOT_FOUND) {
                    this.queryCache.remove(dataQuery);
                }
            });
        }
        YdbTable.ExecuteDataQueryRequest.Builder request = YdbTable.ExecuteDataQueryRequest.newBuilder().setSessionId(this.id).setOperationParams(OperationParamUtils.fromRequestSettings(settings)).setTxControl(txControl.toPb()).setQuery(YdbTable.Query.newBuilder().setYqlText(query)).setCollectStats(settings.collectStats()).putAllParameters(params.toPb());
        boolean keepInServerQueryCache = settings.isKeepInQueryCache();
        boolean bl = keepInClientQueryCache = this.queryCache != null && keepInServerQueryCache;
        if (keepInServerQueryCache) {
            request.getQueryCachePolicyBuilder().setKeepInCache(true);
        }
        String msg = "query";
        if (log.isDebugEnabled() && this.keepQueryText) {
            StringBuilder sb = new StringBuilder(query.replaceAll("\\s", " "));
            if (!params.isEmpty()) {
                sb.append(" [");
                boolean one = true;
                for (Map.Entry<String, Value<?>> entry : params.values().entrySet()) {
                    if (!one) {
                        sb.append(", ");
                    }
                    sb.append(entry.getKey());
                    sb.append("=");
                    sb.append(entry.getValue());
                    one = false;
                }
                sb.append("]");
            }
            msg = sb.toString();
        }
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings(settings);
        return this.interceptResultWithLog(msg, (CompletableFuture)this.tableRpc.executeDataQuery(request.build(), grpcRequestSettings).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            OperationProtos.Operation operation = ((YdbTable.ExecuteDataQueryResponse)response.expect("executeDataQuery()")).getOperation();
            return this.operationTray.waitResult(operation, YdbTable.ExecuteQueryResult.class, result -> this.mapExecuteDataQuery((YdbTable.ExecuteQueryResult)result, query, keepInClientQueryCache), grpcRequestSettings);
        }));
    }

    private DataQueryResult mapExecuteDataQuery(YdbTable.ExecuteQueryResult result, @Nullable String queryText, boolean keepInClientQueryCache) {
        if (keepInClientQueryCache && result.hasQueryMeta() && queryText != null) {
            assert (this.queryCache != null);
            String queryId = result.getQueryMeta().getId();
            Map types = result.getQueryMeta().getParametersTypesMap();
            this.queryCache.put(new DataQueryImpl(this, queryId, queryText, this.keepQueryText, types));
        }
        YdbTable.TransactionMeta txMeta = result.getTxMeta();
        return new DataQueryResult(txMeta.getId(), result.getResultSetsList());
    }

    CompletableFuture<Result<DataQueryResult>> executePreparedDataQuery(String queryId, @Nullable String queryText, TxControl txControl, Params params, ExecuteDataQuerySettings settings) {
        boolean keepInClientQueryCache;
        YdbTable.ExecuteDataQueryRequest.Builder request = YdbTable.ExecuteDataQueryRequest.newBuilder().setSessionId(this.id).setOperationParams(OperationParamUtils.fromRequestSettings(settings)).setTxControl(txControl.toPb()).setCollectStats(settings.collectStats());
        request.getQueryBuilder().setId(queryId);
        request.putAllParameters(params.toPb());
        boolean keepInServerQueryCache = settings.isKeepInQueryCache();
        boolean bl = keepInClientQueryCache = this.queryCache != null && keepInServerQueryCache;
        if (keepInServerQueryCache) {
            request.getQueryCachePolicyBuilder().setKeepInCache(true);
        }
        String msg = "prepared query";
        if (log.isDebugEnabled() && this.keepQueryText) {
            StringBuilder sb = new StringBuilder("prepared,");
            if (queryText != null) {
                sb.append(queryText.replaceAll("\\s", " "));
            }
            if (!params.isEmpty()) {
                sb.append(" [");
                boolean one = true;
                for (Map.Entry<String, Value<?>> entry : params.values().entrySet()) {
                    if (!one) {
                        sb.append(", ");
                    }
                    sb.append(entry.getKey());
                    sb.append("=");
                    sb.append(entry.getValue());
                    one = false;
                }
                sb.append("]");
            }
            msg = sb.toString();
        }
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings(settings);
        return this.interceptResultWithLog(msg, (CompletableFuture)this.tableRpc.executeDataQuery(request.build(), grpcRequestSettings).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            OperationProtos.Operation operation = ((YdbTable.ExecuteDataQueryResponse)response.expect("executeDataQuery()")).getOperation();
            return this.tableRpc.getOperationTray().waitResult(operation, YdbTable.ExecuteQueryResult.class, result -> this.mapExecuteDataQuery((YdbTable.ExecuteQueryResult)result, queryText, keepInClientQueryCache), grpcRequestSettings);
        }));
    }

    @Override
    public CompletableFuture<Result<DataQuery>> prepareDataQuery(String query, PrepareDataQuerySettings settings) {
        YdbTable.PrepareDataQueryRequest.Builder request = YdbTable.PrepareDataQueryRequest.newBuilder().setSessionId(this.id).setOperationParams(OperationParamUtils.fromRequestSettings(settings)).setYqlText(query);
        boolean keepInClientQueryCache = this.queryCache != null && settings.isKeepInQueryCache();
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings(settings);
        return this.interceptResult((CompletableFuture)this.tableRpc.prepareDataQuery(request.build(), grpcRequestSettings).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.operationTray.waitResult(((YdbTable.PrepareDataQueryResponse)response.expect("prepareDataQuery()")).getOperation(), YdbTable.PrepareQueryResult.class, result -> {
                String queryId = result.getQueryId();
                Map types = result.getParametersTypesMap();
                DataQueryImpl dataQuery = new DataQueryImpl(this, queryId, query, this.keepQueryText, types);
                if (keepInClientQueryCache) {
                    this.queryCache.put(dataQuery);
                }
                return dataQuery;
            }, grpcRequestSettings);
        }));
    }

    @Override
    public CompletableFuture<Status> executeSchemeQuery(String query, ExecuteSchemeQuerySettings settings) {
        YdbTable.ExecuteSchemeQueryRequest request = YdbTable.ExecuteSchemeQueryRequest.newBuilder().setSessionId(this.id).setOperationParams(OperationParamUtils.fromRequestSettings(settings)).setYqlText(query).build();
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings(settings);
        return this.interceptStatus((CompletableFuture<Status>)this.tableRpc.executeSchemeQuery(request, grpcRequestSettings).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.ExecuteSchemeQueryResponse)response.expect("executeSchemaQuery()")).getOperation(), grpcRequestSettings);
        }));
    }

    @Override
    public CompletableFuture<Result<ExplainDataQueryResult>> explainDataQuery(String query, ExplainDataQuerySettings settings) {
        YdbTable.ExplainDataQueryRequest request = YdbTable.ExplainDataQueryRequest.newBuilder().setSessionId(this.id).setOperationParams(OperationParamUtils.fromRequestSettings(settings)).setYqlText(query).build();
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings(settings);
        return this.interceptResult((CompletableFuture)this.tableRpc.explainDataQuery(request, grpcRequestSettings).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.operationTray.waitResult(((YdbTable.ExplainDataQueryResponse)response.expect("explainDataQuery()")).getOperation(), YdbTable.ExplainQueryResult.class, result -> new ExplainDataQueryResult(result.getQueryAst(), result.getQueryPlan()), grpcRequestSettings);
        }));
    }

    @Override
    public CompletableFuture<Result<Transaction>> beginTransaction(TransactionMode transactionMode, BeginTxSettings settings) {
        YdbTable.BeginTransactionRequest request = YdbTable.BeginTransactionRequest.newBuilder().setSessionId(this.id).setOperationParams(OperationParamUtils.fromRequestSettings(settings)).setTxSettings(SessionImpl.txSettings(transactionMode)).build();
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings(settings);
        return this.interceptResultWithLog("begin transaction", (CompletableFuture)this.tableRpc.beginTransaction(request, grpcRequestSettings).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.operationTray.waitResult(((YdbTable.BeginTransactionResponse)response.expect("beginTransaction()")).getOperation(), YdbTable.BeginTransactionResult.class, result -> new TransactionImpl(this, result.getTxMeta().getId()), grpcRequestSettings);
        }));
    }

    @Override
    public CompletableFuture<Status> readTable(String tablePath, ReadTableSettings settings, final BiConsumer<ResultSetReader, ReadTableMeta> fn) {
        TupleValue toKey;
        YdbTable.ReadTableRequest.Builder request = YdbTable.ReadTableRequest.newBuilder().setSessionId(this.id).setPath(tablePath).setOrdered(settings.isOrdered()).setRowLimit((long)settings.getRowLimit());
        TupleValue fromKey = settings.getFromKey();
        if (fromKey != null) {
            YdbTable.KeyRange.Builder range = request.getKeyRangeBuilder();
            if (settings.isFromInclusive()) {
                range.setGreaterOrEqual(ProtoValue.toTypedValue(fromKey));
            } else {
                range.setGreater(ProtoValue.toTypedValue(fromKey));
            }
        }
        if ((toKey = settings.getToKey()) != null) {
            YdbTable.KeyRange.Builder range = request.getKeyRangeBuilder();
            if (settings.isToInclusive()) {
                range.setLessOrEqual(ProtoValue.toTypedValue(toKey));
            } else {
                range.setLess(ProtoValue.toTypedValue(toKey));
            }
        }
        if (!settings.getColumns().isEmpty()) {
            request.addAllColumns(settings.getColumns());
        }
        GrpcRequestSettings grpcRequestSettings = GrpcRequestSettings.newBuilder().withDeadlineAfter(settings.getDeadlineAfter()).withPreferredEndpoint(this.endpoint).withTrailersHandler((Consumer)this.shutdownHandler).build();
        final CompletableFuture promise = new CompletableFuture();
        StreamControl control = this.tableRpc.streamReadTable(request.build(), new StreamObserver<YdbTable.ReadTableResponse>(){

            public void onNext(YdbTable.ReadTableResponse response) {
                StatusCodesProtos.StatusIds.StatusCode statusCode = response.getStatus();
                if (statusCode == StatusCodesProtos.StatusIds.StatusCode.SUCCESS) {
                    try {
                        fn.accept(ProtoValueReaders.forResultSet(response.getResult().getResultSet()), new ReadTableMeta(response.getSnapshot()));
                    }
                    catch (Throwable t) {
                        promise.completeExceptionally(t);
                        throw new IllegalStateException(t);
                    }
                } else {
                    Issue[] issues = Issue.fromPb((List)response.getIssuesList());
                    StatusCode code = StatusCode.fromProto((StatusCodesProtos.StatusIds.StatusCode)statusCode);
                    promise.complete(Status.of((StatusCode)code, (Issue[])issues));
                }
            }

            public void onError(Status status) {
                assert (!status.isSuccess());
                promise.complete(status);
            }

            public void onCompleted() {
                promise.complete(Status.SUCCESS);
            }
        }, grpcRequestSettings);
        return promise.whenComplete((status, ex) -> {
            if (ex instanceof CancellationException) {
                control.cancel();
            }
        });
    }

    @Override
    public CompletableFuture<Status> executeScanQuery(String query, Params params, ExecuteScanQuerySettings settings, final Consumer<ResultSetReader> fn) {
        YdbTable.ExecuteScanQueryRequest request = YdbTable.ExecuteScanQueryRequest.newBuilder().setQuery(YdbTable.Query.newBuilder().setYqlText(query)).setMode(settings.getMode()).putAllParameters(params.toPb()).setCollectStats(settings.getCollectStats()).build();
        final CompletableFuture promise = new CompletableFuture();
        GrpcRequestSettings grpcRequestSettings = GrpcRequestSettings.newBuilder().withDeadlineAfter(settings.getDeadlineAfter()).withPreferredEndpoint(this.endpoint).withTrailersHandler((Consumer)this.shutdownHandler).build();
        StreamControl control = this.tableRpc.streamExecuteScanQuery(request, new StreamObserver<YdbTable.ExecuteScanQueryPartialResponse>(){

            public void onNext(YdbTable.ExecuteScanQueryPartialResponse response) {
                StatusCodesProtos.StatusIds.StatusCode statusCode = response.getStatus();
                if (statusCode == StatusCodesProtos.StatusIds.StatusCode.SUCCESS) {
                    try {
                        fn.accept(ProtoValueReaders.forResultSet(response.getResult().getResultSet()));
                    }
                    catch (Throwable t) {
                        promise.completeExceptionally(t);
                        throw new IllegalStateException(t);
                    }
                } else {
                    Issue[] issues = Issue.fromPb((List)response.getIssuesList());
                    StatusCode code = StatusCode.fromProto((StatusCodesProtos.StatusIds.StatusCode)statusCode);
                    promise.complete(Status.of((StatusCode)code, (Issue[])issues));
                }
            }

            public void onError(Status status) {
                assert (!status.isSuccess());
                promise.complete(status);
            }

            public void onCompleted() {
                promise.complete(Status.SUCCESS);
            }
        }, grpcRequestSettings);
        return promise.whenComplete((status, ex) -> {
            if (ex instanceof CancellationException) {
                control.cancel();
            }
        });
    }

    @Override
    public CompletableFuture<Status> commitTransaction(String txId, CommitTxSettings settings) {
        YdbTable.CommitTransactionRequest request = YdbTable.CommitTransactionRequest.newBuilder().setSessionId(this.id).setOperationParams(OperationParamUtils.fromRequestSettings(settings)).setTxId(txId).build();
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings(settings);
        return this.interceptStatusWithLog("commit transaction", (CompletableFuture<Status>)this.tableRpc.commitTransaction(request, grpcRequestSettings).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.tableRpc.getOperationTray().waitStatus(((YdbTable.CommitTransactionResponse)response.expect("commitTransaction()")).getOperation(), grpcRequestSettings);
        }));
    }

    @Override
    public CompletableFuture<Status> rollbackTransaction(String txId, RollbackTxSettings settings) {
        YdbTable.RollbackTransactionRequest request = YdbTable.RollbackTransactionRequest.newBuilder().setSessionId(this.id).setOperationParams(OperationParamUtils.fromRequestSettings(settings)).setTxId(txId).build();
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings(settings);
        return this.interceptStatusWithLog("rollback transaction", (CompletableFuture<Status>)this.tableRpc.rollbackTransaction(request, grpcRequestSettings).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.tableRpc.getOperationTray().waitStatus(((YdbTable.RollbackTransactionResponse)response.expect("rollbackTransaction()")).getOperation(), grpcRequestSettings);
        }));
    }

    @Override
    public CompletableFuture<Result<SessionStatus>> keepAlive(KeepAliveSessionSettings settings) {
        YdbTable.KeepAliveRequest request = YdbTable.KeepAliveRequest.newBuilder().setSessionId(this.id).setOperationParams(OperationParamUtils.fromRequestSettings(settings)).build();
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings(settings);
        return this.interceptResult((CompletableFuture)this.tableRpc.keepAlive(request, grpcRequestSettings).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.operationTray.waitResult(((YdbTable.KeepAliveResponse)response.expect("keepAlive()")).getOperation(), YdbTable.KeepAliveResult.class, SessionImpl::mapSessionStatus, grpcRequestSettings);
        }));
    }

    @Override
    public CompletableFuture<Status> executeBulkUpsert(String tablePath, ListValue rows, BulkUpsertSettings settings) {
        ValueProtos.TypedValue typedRows = ValueProtos.TypedValue.newBuilder().setType(rows.getType().toPb()).setValue(rows.toPb()).build();
        YdbTable.BulkUpsertRequest request = YdbTable.BulkUpsertRequest.newBuilder().setTable(tablePath).setRows(typedRows).setOperationParams(OperationParamUtils.fromRequestSettings(settings)).build();
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings(settings);
        return this.interceptStatus((CompletableFuture<Status>)this.tableRpc.bulkUpsert(request, grpcRequestSettings).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.BulkUpsertResponse)response.expect("bulkUpsert()")).getOperation(), grpcRequestSettings);
        }));
    }

    private static SessionStatus mapSessionStatus(YdbTable.KeepAliveResult result) {
        switch (result.getSessionStatus()) {
            case UNRECOGNIZED: 
            case SESSION_STATUS_UNSPECIFIED: {
                return SessionStatus.UNSPECIFIED;
            }
            case SESSION_STATUS_BUSY: {
                return SessionStatus.BUSY;
            }
            case SESSION_STATUS_READY: {
                return SessionStatus.READY;
            }
        }
        throw new IllegalStateException("unknown session status: " + result.getSessionStatus());
    }

    @Override
    public void invalidateQueryCache() {
        if (this.queryCache != null) {
            this.queryCache.clear();
        }
    }

    @Override
    public boolean release() {
        if (this.sessionPool != null) {
            this.sessionPool.release(this);
            return true;
        }
        return false;
    }

    CompletableFuture<Status> delete(CloseSessionSettings settings) {
        YdbTable.DeleteSessionRequest request = YdbTable.DeleteSessionRequest.newBuilder().setSessionId(this.id).setOperationParams(OperationParamUtils.fromRequestSettings(settings)).build();
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings(settings);
        return this.interceptStatus((CompletableFuture<Status>)this.tableRpc.deleteSession(request, grpcRequestSettings).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.operationTray.waitStatus(((YdbTable.DeleteSessionResponse)response.expect("deleteSession()")).getOperation(), grpcRequestSettings);
        }));
    }

    @Override
    public CompletableFuture<Status> close(CloseSessionSettings settings) {
        return this.delete(settings).thenApply(response -> {
            if (response.isSuccess() && this.sessionPool != null) {
                this.sessionPool.delete(this);
            }
            return response;
        });
    }

    private <T> CompletableFuture<Result<T>> interceptResultWithLog(String msg, CompletableFuture<Result<T>> future) {
        long start = Instant.now().toEpochMilli();
        return future.whenComplete((r, t) -> {
            long ms = Instant.now().toEpochMilli() - start;
            log.debug("Session[{}] {} => {}, took {} ms", new Object[]{this.hashCode(), msg, r.getCode(), ms});
            this.changeSessionState((Throwable)t, r.getCode());
        });
    }

    private <T> CompletableFuture<Result<T>> interceptResult(CompletableFuture<Result<T>> future) {
        return future.whenComplete((r, t) -> this.changeSessionState((Throwable)t, r.getCode()));
    }

    private CompletableFuture<Status> interceptStatus(CompletableFuture<Status> future) {
        return future.whenComplete((r, t) -> this.changeSessionState((Throwable)t, r.getCode()));
    }

    private CompletableFuture<Status> interceptStatusWithLog(String msg, CompletableFuture<Status> future) {
        long start = Instant.now().toEpochMilli();
        return future.whenComplete((r, t) -> {
            long ms = Instant.now().toEpochMilli() - start;
            log.debug("Session[{}] {} => {}, took {} ms", new Object[]{this.hashCode(), msg, r.getCode(), ms});
            this.changeSessionState((Throwable)t, r.getCode());
        });
    }

    private void changeSessionState(Throwable t, StatusCode code) {
        State oldState = this.getState();
        if (t != null) {
            this.switchState(oldState, State.BROKEN);
            return;
        }
        if (code.isTransportError() && code != StatusCode.CLIENT_RESOURCE_EXHAUSTED) {
            this.switchState(oldState, State.DISCONNECTED);
        } else if (code == StatusCode.BAD_SESSION) {
            this.switchState(oldState, State.BROKEN);
        } else if (code == StatusCode.SESSION_BUSY) {
            this.switchState(oldState, State.BROKEN);
        } else if (code == StatusCode.INTERNAL_ERROR) {
            this.switchState(oldState, State.BROKEN);
        }
    }

    public String toString() {
        return "Session{id='" + this.id + '\'' + ", state=" + (Object)((Object)this.state) + '}';
    }

    private static class ShutdownHandler
    implements Consumer<Metadata> {
        private static final String GRACEFUL_SHUTDOWN_HINT = "session-close";
        private volatile boolean needShutdown = false;

        private ShutdownHandler() {
        }

        public boolean isGracefulShutdown() {
            return this.needShutdown;
        }

        @Override
        public void accept(Metadata metadata) {
            if (metadata == null) {
                return;
            }
            Iterable serverHints = metadata.getAll(YdbHeaders.YDB_SERVER_HINTS);
            if (serverHints != null) {
                for (String value : serverHints) {
                    if (!GRACEFUL_SHUTDOWN_HINT.equals(value)) continue;
                    this.needShutdown = true;
                    return;
                }
            }
        }
    }

    static enum State {
        IDLE,
        BROKEN,
        ACTIVE,
        DISCONNECTED;

    }
}

