/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.impl;

import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.UnexpectedResultException;
import com.yandex.ydb.core.utils.Async;
import com.yandex.ydb.table.Session;
import com.yandex.ydb.table.SessionStatus;
import com.yandex.ydb.table.impl.SessionImpl;
import com.yandex.ydb.table.impl.SessionPoolOptions;
import com.yandex.ydb.table.impl.TableClientImpl;
import com.yandex.ydb.table.impl.pool.FixedAsyncPool;
import com.yandex.ydb.table.impl.pool.PooledObjectHandler;
import com.yandex.ydb.table.settings.CloseSessionSettings;
import com.yandex.ydb.table.settings.CreateSessionSettings;
import com.yandex.ydb.table.stats.SessionPoolStats;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SessionPool
implements PooledObjectHandler<SessionImpl> {
    private static final Logger logger = LoggerFactory.getLogger(SessionPool.class);
    private final TableClientImpl tableClient;
    private final FixedAsyncPool<SessionImpl> idlePool;
    private final int minSize;
    private final int maxSize;

    SessionPool(TableClientImpl tableClient, SessionPoolOptions options) {
        this.tableClient = tableClient;
        this.minSize = options.getMinSize();
        this.maxSize = options.getMaxSize();
        this.idlePool = new FixedAsyncPool<SessionImpl>(this, this.minSize, this.maxSize, this.maxSize * 2, options.getKeepAliveTimeMillis(), options.getMaxIdleTimeMillis());
    }

    @Override
    public CompletableFuture<SessionImpl> create(long deadlineAfter) {
        return this.tableClient.createSessionImpl((CreateSessionSettings)new CreateSessionSettings().setDeadlineAfter(deadlineAfter), this).thenApply(r -> {
            SessionImpl session = (SessionImpl)r.expect("cannot create session");
            session.setState(SessionImpl.State.IDLE);
            return session;
        });
    }

    @Override
    public CompletableFuture<Void> destroy(SessionImpl s) {
        return s.delete(new CloseSessionSettings()).thenAccept(r -> r.expect("cannot close session: " + s.getId()));
    }

    @Override
    public boolean isValid(SessionImpl s) {
        return s.switchState(SessionImpl.State.ACTIVE, SessionImpl.State.IDLE);
    }

    @Override
    public CompletableFuture<Result<SessionStatus>> keepAlive(SessionImpl s) {
        return s.keepAlive();
    }

    CompletableFuture<Result<Session>> acquire(Duration timeout) {
        CompletableFuture<Result<Session>> future = new CompletableFuture<Result<Session>>();
        Instant expireTime = Instant.now().plusNanos(timeout.toNanos());
        this.tryAcquire(future, expireTime);
        return future;
    }

    private void tryAcquire(CompletableFuture<Result<Session>> future, Instant expireTime) {
        Duration timeout = Duration.between(Instant.now(), expireTime);
        this.idlePool.acquire(timeout.isNegative() ? Duration.ZERO : timeout).whenComplete((session, th) -> {
            if (future.isDone()) {
                if (session != null) {
                    session.switchState(SessionImpl.State.IDLE, SessionImpl.State.ACTIVE);
                    this.release((SessionImpl)session);
                }
                return;
            }
            if (th != null) {
                Throwable unwrapped = Async.unwrapCompletionException((Throwable)th);
                if (unwrapped instanceof UnexpectedResultException) {
                    future.complete(Result.fail((UnexpectedResultException)((UnexpectedResultException)unwrapped)));
                } else {
                    future.complete(Result.error((String)"cannot acquire session from pool", (Throwable)unwrapped));
                }
                return;
            }
            if (session != null) {
                if (session.switchState(SessionImpl.State.IDLE, SessionImpl.State.ACTIVE)) {
                    logger.trace("Acquire session '{}'", session);
                    if (!future.complete(Result.success((Object)session))) {
                        this.release((SessionImpl)session);
                    }
                } else {
                    this.release((SessionImpl)session);
                    this.tryAcquire(future, expireTime);
                }
            }
        });
    }

    void release(SessionImpl session) {
        if (session.switchState(SessionImpl.State.DISCONNECTED, SessionImpl.State.IDLE)) {
            logger.trace("Destroy session '{}' because disconnected", (Object)session);
            session.close();
            this.idlePool.delete(session);
        } else if (session.isGracefulShutdown()) {
            logger.trace("Destroy session '{}' because graceful shutdown hook was received", (Object)session);
            session.close();
            this.idlePool.delete(session);
        } else {
            logger.trace("Release session '{}'", (Object)session);
            this.idlePool.release(session);
        }
    }

    void delete(SessionImpl session) {
        this.idlePool.delete(session);
    }

    void close() {
        this.idlePool.close();
    }

    public SessionPoolStats getStats() {
        return new SessionPoolStats(this.minSize, this.maxSize, this.idlePool.getIdleCount(), 0, this.idlePool.getAcquiredCount(), this.idlePool.getPendingAcquireCount());
    }
}

