/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.query.Params;
import com.yandex.ydb.table.values.Type;
import com.yandex.ydb.table.values.Value;
import com.yandex.ydb.table.values.proto.ProtoValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class ParamsImmutableMap
implements Params {
    static final ParamsImmutableMap EMPTY = new ParamsImmutableMap(Collections.emptyMap());
    private final Map<String, Value<?>> params;

    private ParamsImmutableMap(Map<String, Value<?>> params) {
        this.params = params;
    }

    static ParamsImmutableMap create(String name, Value<?> value) {
        return new ParamsImmutableMap(Collections.singletonMap(name, value));
    }

    static ParamsImmutableMap create(String name1, Value<?> value1, String name2, Value<?> value2) {
        Preconditions.checkArgument((!name1.equals(name2) ? 1 : 0) != 0, (String)"parameter duplicate: %s", (Object)name1);
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put(name1, value1);
        params.put(name2, value2);
        return new ParamsImmutableMap(Collections.unmodifiableMap(params));
    }

    static ParamsImmutableMap create(String name1, Value<?> value1, String name2, Value<?> value2, String name3, Value<?> value3) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)3);
        params.put(name1, value1);
        ParamsImmutableMap.putParam(params, name2, value2);
        ParamsImmutableMap.putParam(params, name3, value3);
        return new ParamsImmutableMap(Collections.unmodifiableMap(params));
    }

    static ParamsImmutableMap create(String name1, Value<?> value1, String name2, Value<?> value2, String name3, Value<?> value3, String name4, Value<?> value4) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)4);
        params.put(name1, value1);
        ParamsImmutableMap.putParam(params, name2, value2);
        ParamsImmutableMap.putParam(params, name3, value3);
        ParamsImmutableMap.putParam(params, name4, value4);
        return new ParamsImmutableMap(Collections.unmodifiableMap(params));
    }

    static ParamsImmutableMap create(String name1, Value<?> value1, String name2, Value<?> value2, String name3, Value<?> value3, String name4, Value<?> value4, String name5, Value<?> value5) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)5);
        params.put(name1, value1);
        ParamsImmutableMap.putParam(params, name2, value2);
        ParamsImmutableMap.putParam(params, name3, value3);
        ParamsImmutableMap.putParam(params, name4, value4);
        ParamsImmutableMap.putParam(params, name5, value5);
        return new ParamsImmutableMap(Collections.unmodifiableMap(params));
    }

    static ParamsImmutableMap create(String name1, Value<?> value1, String name2, Value<?> value2, String name3, Value<?> value3, String name4, Value<?> value4, String name5, Value<?> value5, String name6, Value<?> value6) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)6);
        params.put(name1, value1);
        ParamsImmutableMap.putParam(params, name2, value2);
        ParamsImmutableMap.putParam(params, name3, value3);
        ParamsImmutableMap.putParam(params, name4, value4);
        ParamsImmutableMap.putParam(params, name5, value5);
        ParamsImmutableMap.putParam(params, name6, value6);
        return new ParamsImmutableMap(Collections.unmodifiableMap(params));
    }

    static ParamsImmutableMap create(String name1, Value<?> value1, String name2, Value<?> value2, String name3, Value<?> value3, String name4, Value<?> value4, String name5, Value<?> value5, String name6, Value<?> value6, String name7, Value<?> value7, String name8, Value<?> value8) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)8);
        params.put(name1, value1);
        ParamsImmutableMap.putParam(params, name2, value2);
        ParamsImmutableMap.putParam(params, name3, value3);
        ParamsImmutableMap.putParam(params, name4, value4);
        ParamsImmutableMap.putParam(params, name5, value5);
        ParamsImmutableMap.putParam(params, name6, value6);
        ParamsImmutableMap.putParam(params, name7, value7);
        ParamsImmutableMap.putParam(params, name8, value8);
        return new ParamsImmutableMap(Collections.unmodifiableMap(params));
    }

    static ParamsImmutableMap create(String name1, Value<?> value1, String name2, Value<?> value2, String name3, Value<?> value3, String name4, Value<?> value4, String name5, Value<?> value5, String name6, Value<?> value6, String name7, Value<?> value7, String name8, Value<?> value8, String name9, Value<?> value9) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)9);
        params.put(name1, value1);
        ParamsImmutableMap.putParam(params, name2, value2);
        ParamsImmutableMap.putParam(params, name3, value3);
        ParamsImmutableMap.putParam(params, name4, value4);
        ParamsImmutableMap.putParam(params, name5, value5);
        ParamsImmutableMap.putParam(params, name6, value6);
        ParamsImmutableMap.putParam(params, name7, value7);
        ParamsImmutableMap.putParam(params, name8, value8);
        ParamsImmutableMap.putParam(params, name9, value9);
        return new ParamsImmutableMap(Collections.unmodifiableMap(params));
    }

    private static void putParam(HashMap<String, Value<?>> params, String name, Value<?> value) {
        Preconditions.checkArgument((params.putIfAbsent(name, value) == null ? 1 : 0) != 0, (String)"parameter duplicate: %s", (Object)name);
    }

    @Override
    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    @Override
    public <T extends Type> Params put(String name, Value<T> value) {
        throw new UnsupportedOperationException("cannot put parameter into immutable params map");
    }

    @Override
    public Map<String, ValueProtos.TypedValue> toPb() {
        HashMap result = Maps.newHashMapWithExpectedSize((int)this.params.size());
        for (Map.Entry<String, Value<?>> entry : this.params.entrySet()) {
            result.put(entry.getKey(), ProtoValue.toTypedValue(entry.getValue()));
        }
        return result;
    }

    @Override
    public Map<String, Value<?>> values() {
        return Collections.unmodifiableMap(this.params);
    }
}

