/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.result.impl;

import com.google.common.collect.Maps;
import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.result.ValueReader;
import com.yandex.ydb.table.result.impl.AbstractValueReader;
import java.util.HashMap;
import java.util.Map;

final class ProtoStructValueReader
extends AbstractValueReader {
    private final ValueProtos.Type type;
    private final AbstractValueReader[] memberReaders;
    private final Map<String, Integer> nameIdx;
    private ValueProtos.Value value;

    ProtoStructValueReader(ValueProtos.Type type, AbstractValueReader[] memberReaders) {
        this.type = type;
        this.memberReaders = memberReaders;
        this.nameIdx = ProtoStructValueReader.buildNameIdx(type.getStructType());
    }

    private static HashMap<String, Integer> buildNameIdx(ValueProtos.StructType structType) {
        HashMap nameIdx = Maps.newHashMapWithExpectedSize((int)structType.getMembersCount());
        for (int i = 0; i < structType.getMembersCount(); ++i) {
            nameIdx.put(structType.getMembers(i).getName(), i);
        }
        return nameIdx;
    }

    @Override
    protected ValueProtos.Type getProtoType() {
        return this.type;
    }

    @Override
    protected ValueProtos.Value getProtoValue() {
        return this.value;
    }

    @Override
    protected void setProtoValue(ValueProtos.Value value) {
        this.value = value;
    }

    @Override
    public int getStructMembersCount() {
        return this.memberReaders.length;
    }

    @Override
    public String getStructMemberName(int index) {
        return this.type.getStructType().getMembers(index).getName();
    }

    @Override
    public ValueReader getStructMember(int index) {
        AbstractValueReader memberReader = this.memberReaders[index];
        memberReader.setProtoValue(this.value.getItems(index));
        return memberReader;
    }

    @Override
    public ValueReader getStructMember(String name) {
        Integer index = this.nameIdx.get(name);
        if (index == null) {
            throw new IllegalArgumentException("unknown member name: '" + name + '\'');
        }
        return this.getStructMember(index);
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("Struct[");
        for (int i = 0; i < this.getStructMembersCount(); ++i) {
            String name = this.getStructMemberName(i);
            sb.append(name).append(": ");
            this.getStructMember(i).toString(sb);
            sb.append(", ");
        }
        if (this.getStructMembersCount() > 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
    }
}

