/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.settings;

import com.google.protobuf.Duration;
import com.yandex.ydb.table.YdbTable;
import java.util.Objects;

public class Changefeed {
    private final String name;
    private final Mode mode;
    private final Format format;
    private final boolean virtualTimestamps;
    private final java.time.Duration retentionPeriod;
    private final boolean initialScan;

    public Changefeed(String name, Mode mode, Format format) {
        this(name, mode, format, false, java.time.Duration.ofHours(24L), false);
    }

    public Changefeed(String name, Mode mode, Format format, boolean virtualTimestamps, java.time.Duration retentionPeriod) {
        this(name, mode, format, virtualTimestamps, retentionPeriod, false);
    }

    public Changefeed(String name, Mode mode, Format format, boolean virtualTimestamps, java.time.Duration retentionPeriod, boolean initialScan) {
        this.name = Objects.requireNonNull(name);
        this.mode = Objects.requireNonNull(mode);
        this.format = Objects.requireNonNull(format);
        this.virtualTimestamps = virtualTimestamps;
        this.retentionPeriod = retentionPeriod;
        this.initialScan = initialScan;
    }

    public String getName() {
        return this.name;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Format getFormat() {
        return this.format;
    }

    public boolean hasVirtualTimestamps() {
        return this.virtualTimestamps;
    }

    public boolean hasInitialScan() {
        return this.initialScan;
    }

    public java.time.Duration getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public YdbTable.Changefeed toProto() {
        return YdbTable.Changefeed.newBuilder().setName(this.name).setFormat(this.format.toProto()).setMode(this.mode.toProto()).setVirtualTimestamps(this.virtualTimestamps).setRetentionPeriod(Changefeed.toProto(this.retentionPeriod)).setInitialScan(this.initialScan).build();
    }

    private static Duration toProto(java.time.Duration duration) {
        return Duration.newBuilder().setSeconds(duration.getSeconds()).setNanos(duration.getNano()).build();
    }

    public static enum Format {
        JSON(YdbTable.ChangefeedFormat.Format.FORMAT_JSON);

        private final YdbTable.ChangefeedFormat.Format proto;

        private Format(YdbTable.ChangefeedFormat.Format proto) {
            this.proto = proto;
        }

        YdbTable.ChangefeedFormat.Format toProto() {
            return this.proto;
        }
    }

    public static enum Mode {
        KEYS_ONLY(YdbTable.ChangefeedMode.Mode.MODE_KEYS_ONLY),
        UPDATES(YdbTable.ChangefeedMode.Mode.MODE_UPDATES),
        NEW_IMAGE(YdbTable.ChangefeedMode.Mode.MODE_NEW_IMAGE),
        OLD_IMAGE(YdbTable.ChangefeedMode.Mode.MODE_OLD_IMAGE),
        NEW_AND_OLD_IMAGES(YdbTable.ChangefeedMode.Mode.MODE_NEW_AND_OLD_IMAGES);

        private final YdbTable.ChangefeedMode.Mode proto;

        private Mode(YdbTable.ChangefeedMode.Mode proto) {
            this.proto = proto;
        }

        YdbTable.ChangefeedMode.Mode toProto() {
            return this.proto;
        }
    }
}

