/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.settings;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.yandex.ydb.table.values.PrimitiveValue;
import com.yandex.ydb.table.values.TupleValue;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ReadTableSettings {
    private final boolean ordered;
    private final TupleValue fromKey;
    private final boolean fromInclusive;
    private final TupleValue toKey;
    private final boolean toInclusive;
    private final int rowLimit;
    private final ImmutableList<String> columns;
    private final long timeoutNanos;

    private ReadTableSettings(Builder b) {
        this.ordered = b.ordered;
        this.fromKey = b.fromKey;
        this.fromInclusive = b.fromInclusive;
        this.toKey = b.toKey;
        this.toInclusive = b.toInclusive;
        this.rowLimit = b.rowLimit;
        this.columns = ImmutableList.copyOf((Collection)b.columns);
        this.timeoutNanos = b.timeoutNanos;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    @Nullable
    public TupleValue getFromKey() {
        return this.fromKey;
    }

    public boolean isFromInclusive() {
        return this.fromInclusive;
    }

    @Nullable
    public TupleValue getToKey() {
        return this.toKey;
    }

    public boolean isToInclusive() {
        return this.toInclusive;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public ImmutableList<String> getColumns() {
        return this.columns;
    }

    public long getTimeoutNanos() {
        return this.timeoutNanos;
    }

    public long getDeadlineAfter() {
        return System.nanoTime() + this.timeoutNanos;
    }

    @ParametersAreNonnullByDefault
    public static final class Builder {
        private boolean ordered = false;
        private TupleValue fromKey = null;
        private boolean fromInclusive = false;
        private TupleValue toKey = null;
        private boolean toInclusive = false;
        private int rowLimit = 0;
        private List<String> columns = Collections.emptyList();
        private long timeoutNanos = 0L;

        Builder() {
        }

        public Builder orderedRead(boolean ordered) {
            this.ordered = ordered;
            return this;
        }

        public Builder fromKey(TupleValue value, boolean inclusive) {
            this.fromKey = value;
            this.fromInclusive = inclusive;
            return this;
        }

        public Builder toKey(TupleValue value, boolean inclusive) {
            this.toKey = value;
            this.toInclusive = inclusive;
            return this;
        }

        public Builder fromKeyInclusive(TupleValue value) {
            return this.fromKey(value, true);
        }

        public Builder fromKeyExclusive(TupleValue value) {
            return this.fromKey(value, false);
        }

        public Builder fromKeyInclusive(PrimitiveValue value) {
            return this.fromKey(TupleValue.of(value.makeOptional()), true);
        }

        public Builder fromKeyExclusive(PrimitiveValue value) {
            return this.fromKey(TupleValue.of(value.makeOptional()), false);
        }

        public Builder toKeyInclusive(TupleValue value) {
            return this.toKey(value, true);
        }

        public Builder toKeyExclusive(TupleValue value) {
            return this.toKey(value, false);
        }

        public Builder toKeyInclusive(PrimitiveValue value) {
            return this.toKey(TupleValue.of(value.makeOptional()), true);
        }

        public Builder toKeyExclusive(PrimitiveValue value) {
            return this.toKey(TupleValue.of(value.makeOptional()), false);
        }

        public Builder rowLimit(int rowLimit) {
            Preconditions.checkArgument((rowLimit >= 0 ? 1 : 0) != 0, (String)"rowLimit(%d) is negative", (int)rowLimit);
            this.rowLimit = rowLimit;
            return this;
        }

        public Builder columns(List<String> columns) {
            this.columns = columns;
            return this;
        }

        public Builder columns(String ... columns) {
            this.columns = ImmutableList.copyOf((Object[])columns);
            return this;
        }

        public Builder column(String column) {
            if (!(this.columns instanceof ArrayList)) {
                this.columns = new ArrayList<String>(this.columns);
            }
            this.columns.add(column);
            return this;
        }

        public Builder timeout(long duration, TimeUnit unit) {
            this.timeoutNanos = unit.toNanos(duration);
            return this;
        }

        public Builder timeout(Duration duration) {
            this.timeoutNanos = duration.toNanos();
            return this;
        }

        public ReadTableSettings build() {
            return new ReadTableSettings(this);
        }
    }
}

