/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.settings;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class RequestSettings<Self extends RequestSettings> {
    private String traceId;
    private long deadlineAfter;
    private Duration operationTimeout;
    private Duration cancelAfter;
    private Duration timeout;
    private Boolean reportCostInfo;

    public String getTraceId() {
        return this.traceId;
    }

    public Self setTraceId(String traceId) {
        this.traceId = traceId;
        return this.self();
    }

    public Optional<Duration> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    public Self setTimeout(Duration duration) {
        if (duration.compareTo(Duration.ZERO) >= 0) {
            this.timeout = duration;
        }
        return this.self();
    }

    public Self setTimeout(long duration, TimeUnit unit) {
        if (duration >= 0L) {
            this.timeout = Duration.ofNanos(unit.toNanos(duration));
        }
        return this.self();
    }

    public long getDeadlineAfter() {
        return this.deadlineAfter;
    }

    public Self setDeadlineAfter(long deadlineAfter) {
        this.deadlineAfter = Math.max(0L, deadlineAfter);
        return this.self();
    }

    private Self self() {
        return (Self)this;
    }

    public Optional<Duration> getOperationTimeout() {
        return Optional.ofNullable(this.operationTimeout);
    }

    public Self setOperationTimeout(Duration operationTimeout) {
        this.operationTimeout = operationTimeout;
        return this.self();
    }

    public Optional<Duration> getCancelAfter() {
        return Optional.ofNullable(this.cancelAfter);
    }

    public Self setCancelAfter(Duration cancelAfter) {
        this.cancelAfter = cancelAfter;
        return this.self();
    }

    public Optional<Boolean> getReportCostInfo() {
        return Optional.ofNullable(this.reportCostInfo);
    }

    public Self setReportCostInfo(Boolean reportCostInfo) {
        this.reportCostInfo = reportCostInfo;
        return this.self();
    }
}

