/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table;

import com.yandex.ydb.core.Result;
import com.yandex.ydb.table.Session;
import com.yandex.ydb.table.SessionSupplier;
import com.yandex.ydb.table.impl.TableClientBuilderImpl;
import com.yandex.ydb.table.rpc.TableRpc;
import com.yandex.ydb.table.settings.CreateSessionSettings;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import javax.annotation.WillClose;

public interface TableClient
extends SessionSupplier,
AutoCloseable {
    public static Builder newClient(@WillClose TableRpc tableRpc) {
        return new TableClientBuilderImpl(tableRpc);
    }

    public CompletableFuture<Result<Session>> createSession(CreateSessionSettings var1);

    default public CompletableFuture<Result<Session>> createSession() {
        return this.createSession(new CreateSessionSettings());
    }

    @Override
    public void close();

    public static interface Builder {
        public Builder queryCacheSize(int var1);

        public Builder keepQueryText(boolean var1);

        public Builder sessionPoolSize(int var1, int var2);

        public Builder sessionKeepAliveTime(Duration var1);

        public Builder sessionMaxIdleTime(Duration var1);

        public Builder sessionCreationMaxRetries(int var1);

        public TableClient build();
    }
}

