/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.impl;

import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.Status;
import com.yandex.ydb.scheme.SchemeOperationProtos;
import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.description.DescribePathResult;
import com.yandex.ydb.table.description.ListDirectoryResult;
import com.yandex.ydb.table.impl.SchemeClientBuilderImpl;
import com.yandex.ydb.table.rpc.SchemeRpc;
import java.util.concurrent.CompletableFuture;

final class SchemeClientImpl
implements SchemeClient {
    private final SchemeRpc schemeRpc;

    SchemeClientImpl(SchemeClientBuilderImpl builder) {
        this.schemeRpc = builder.schemeRpc;
    }

    @Override
    public CompletableFuture<Status> makeDirectory(String path) {
        SchemeOperationProtos.MakeDirectoryRequest request = SchemeOperationProtos.MakeDirectoryRequest.newBuilder().setPath(path).build();
        long deadlineAfter = 0L;
        return this.schemeRpc.makeDirectory(request, 0L).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.schemeRpc.getOperationTray().waitStatus(((SchemeOperationProtos.MakeDirectoryResponse)response.expect("makeDirectory()")).getOperation(), 0L);
        });
    }

    @Override
    public CompletableFuture<Status> removeDirectory(String path) {
        SchemeOperationProtos.RemoveDirectoryRequest request = SchemeOperationProtos.RemoveDirectoryRequest.newBuilder().setPath(path).build();
        long deadlineAfter = 0L;
        return this.schemeRpc.removeDirectory(request, 0L).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.schemeRpc.getOperationTray().waitStatus(((SchemeOperationProtos.RemoveDirectoryResponse)response.expect("removeDirectory()")).getOperation(), 0L);
        });
    }

    @Override
    public CompletableFuture<Result<DescribePathResult>> describePath(String path) {
        SchemeOperationProtos.DescribePathRequest request = SchemeOperationProtos.DescribePathRequest.newBuilder().setPath(path).build();
        long deadlineAfter = 0L;
        return this.schemeRpc.describePath(request, 0L).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.schemeRpc.getOperationTray().waitResult(((SchemeOperationProtos.DescribePathResponse)response.expect("describePath()")).getOperation(), SchemeOperationProtos.DescribePathResult.class, result -> new DescribePathResult(result.getSelf()), 0L);
        });
    }

    @Override
    public CompletableFuture<Result<ListDirectoryResult>> listDirectory(String path) {
        SchemeOperationProtos.ListDirectoryRequest request = SchemeOperationProtos.ListDirectoryRequest.newBuilder().setPath(path).build();
        long deadlineAfter = 0L;
        return this.schemeRpc.describeDirectory(request, 0L).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.schemeRpc.getOperationTray().waitResult(((SchemeOperationProtos.ListDirectoryResponse)response.expect("describeDirectory()")).getOperation(), SchemeOperationProtos.ListDirectoryResult.class, result -> new ListDirectoryResult(result.getSelf(), result.getChildrenList()), 0L);
        });
    }

    @Override
    public void close() {
        this.schemeRpc.close();
    }
}

