/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.impl;

import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.rpc.OperationTray;
import com.yandex.ydb.table.Session;
import com.yandex.ydb.table.TableClient;
import com.yandex.ydb.table.YdbTable;
import com.yandex.ydb.table.impl.SessionImpl;
import com.yandex.ydb.table.impl.SessionPool;
import com.yandex.ydb.table.impl.TableClientBuilderImpl;
import com.yandex.ydb.table.rpc.TableRpc;
import com.yandex.ydb.table.settings.CreateSessionSettings;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

final class TableClientImpl
implements TableClient {
    private final TableRpc tableRpc;
    @Nullable
    private final SessionPool sessionPool;
    private final OperationTray operationTray;
    private final int queryCacheSize;
    private final boolean keepQueryText;

    TableClientImpl(TableClientBuilderImpl builder) {
        this.tableRpc = builder.tableRpc;
        this.sessionPool = builder.sessionPoolOptions.getMaxSize() != 0 ? new SessionPool(this, builder.sessionPoolOptions) : null;
        this.operationTray = this.tableRpc.getOperationTray();
        this.queryCacheSize = builder.queryCacheSize;
        this.keepQueryText = builder.keepQueryText;
    }

    @Override
    public CompletableFuture<Result<Session>> createSession(CreateSessionSettings settings) {
        return this.createSessionImpl(settings, null);
    }

    CompletableFuture<Result<Session>> createSessionImpl(CreateSessionSettings settings, @Nullable SessionPool sessionPool) {
        YdbTable.CreateSessionRequest request = YdbTable.CreateSessionRequest.newBuilder().build();
        long deadlineAfter = settings.getDeadlineAfter();
        return this.tableRpc.createSession(request, deadlineAfter).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.operationTray.waitResult(((YdbTable.CreateSessionResponse)response.expect("createSession()")).getOperation(), YdbTable.CreateSessionResult.class, result -> new SessionImpl(result.getSessionId(), this.tableRpc, sessionPool, this.queryCacheSize, this.keepQueryText), deadlineAfter);
        });
    }

    @Override
    public CompletableFuture<Result<Session>> getOrCreateSession(Duration timeout) {
        if (this.sessionPool == null) {
            return this.createSessionImpl((CreateSessionSettings)new CreateSessionSettings().setTimeout(timeout), null);
        }
        return this.sessionPool.acquire(timeout).handle((s, t) -> {
            if (t == null) {
                return Result.success((Object)s);
            }
            return Result.error((String)"cannot acquire session from pool", (Throwable)t);
        });
    }

    @Override
    public void close() {
        if (this.sessionPool != null) {
            this.sessionPool.close();
        }
        this.tableRpc.close();
    }
}

