/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.result.impl;

import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.result.ValueReader;
import com.yandex.ydb.table.result.impl.AbstractValueReader;

final class ProtoOptionalValueReader
extends AbstractValueReader {
    private final ValueProtos.Type type;
    private final AbstractValueReader itemReader;
    private boolean present = false;

    ProtoOptionalValueReader(ValueProtos.Type type, AbstractValueReader itemReader) {
        this.type = type;
        this.itemReader = itemReader;
    }

    @Override
    protected ValueProtos.Type getType() {
        return this.type;
    }

    @Override
    protected void setValue(ValueProtos.Value value) {
        switch (value.getValueCase()) {
            case NESTED_VALUE: {
                this.present = true;
                this.itemReader.setValue(value.getNestedValue());
                break;
            }
            case NULL_FLAG_VALUE: {
                this.present = false;
                this.itemReader.setValue(ValueProtos.Value.getDefaultInstance());
                break;
            }
            default: {
                this.present = true;
                this.itemReader.setValue(value);
            }
        }
    }

    @Override
    public boolean isOptionalItemPresent() {
        return this.present;
    }

    @Override
    public ValueReader getOptionalItem() {
        return this.itemReader;
    }

    @Override
    public void toString(StringBuilder sb) {
        if (this.isOptionalItemPresent()) {
            sb.append("Some[");
            this.getOptionalItem().toString(sb);
            sb.append(']');
        } else {
            sb.append("Empty[]");
        }
    }
}

