/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.transaction;

import com.yandex.ydb.table.YdbTable;
import com.yandex.ydb.table.transaction.Transaction;

public abstract class TxControl<Self extends TxControl> {
    private boolean commitTx;

    public static TxControl id(String id) {
        return new TxId(id);
    }

    public static TxControl id(Transaction tx) {
        return new TxId(tx.getId());
    }

    public static TxSerializableRw serializableRw() {
        return new TxSerializableRw();
    }

    public static TxOnlineRo onlineRo() {
        return new TxOnlineRo();
    }

    public static TxStaleRo staleRo() {
        return new TxStaleRo();
    }

    public boolean isCommitTx() {
        return this.commitTx;
    }

    public Self setCommitTx(boolean commitTx) {
        this.commitTx = commitTx;
        return (Self)this;
    }

    public abstract YdbTable.TransactionControl toPb();

    public static final class TxOnlineRo
    extends TxControl<TxOnlineRo> {
        private boolean allowInconsistentReads;

        private TxOnlineRo() {
        }

        public boolean allowInconsistentReads() {
            return this.allowInconsistentReads;
        }

        public TxOnlineRo setAllowInconsistentReads(boolean allowInconsistentReads) {
            this.allowInconsistentReads = allowInconsistentReads;
            return this;
        }

        @Override
        public YdbTable.TransactionControl toPb() {
            YdbTable.TransactionControl.Builder builder = YdbTable.TransactionControl.newBuilder().setCommitTx(this.isCommitTx());
            builder.getBeginTxBuilder().getOnlineReadOnlyBuilder().setAllowInconsistentReads(this.allowInconsistentReads);
            return builder.build();
        }
    }

    public static final class TxStaleRo
    extends TxControl<TxStaleRo> {
        private TxStaleRo() {
        }

        @Override
        public YdbTable.TransactionControl toPb() {
            YdbTable.TransactionControl.Builder builder = YdbTable.TransactionControl.newBuilder().setCommitTx(this.isCommitTx());
            builder.getBeginTxBuilder().setStaleReadOnly(YdbTable.StaleModeSettings.getDefaultInstance());
            return builder.build();
        }
    }

    public static final class TxSerializableRw
    extends TxControl<TxSerializableRw> {
        private TxSerializableRw() {
        }

        @Override
        public YdbTable.TransactionControl toPb() {
            YdbTable.TransactionControl.Builder builder = YdbTable.TransactionControl.newBuilder().setCommitTx(this.isCommitTx());
            builder.getBeginTxBuilder().setSerializableReadWrite(YdbTable.SerializableModeSettings.getDefaultInstance());
            return builder.build();
        }
    }

    public static final class TxId
    extends TxControl<TxId> {
        private final String id;

        private TxId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public YdbTable.TransactionControl toPb() {
            return YdbTable.TransactionControl.newBuilder().setCommitTx(this.isCommitTx()).setTxId(this.id).build();
        }
    }
}

