/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.impl;

import com.yandex.ydb.table.SessionStatus;
import com.yandex.ydb.table.impl.SessionImpl;
import com.yandex.ydb.table.impl.SessionPoolOptions;
import com.yandex.ydb.table.impl.TableClientImpl;
import com.yandex.ydb.table.impl.pool.FixedAsyncPool;
import com.yandex.ydb.table.impl.pool.PooledObjectHandler;
import com.yandex.ydb.table.impl.pool.SettlersPool;
import com.yandex.ydb.table.settings.CreateSessionSettings;
import com.yandex.ydb.table.stats.SessionPoolStats;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SessionPool
implements PooledObjectHandler<SessionImpl> {
    private static final Logger logger = Logger.getLogger(SessionPool.class.getName());
    private final TableClientImpl tableClient;
    private final FixedAsyncPool<SessionImpl> idlePool;
    private final SettlersPool<SessionImpl> settlersPool;
    private final Timer timer;
    private final int minSize;
    private final int maxSize;

    SessionPool(TableClientImpl tableClient, SessionPoolOptions options) {
        this.tableClient = tableClient;
        this.minSize = options.getMinSize();
        this.maxSize = options.getMaxSize();
        this.timer = new HashedWheelTimer((ThreadFactory)new DefaultThreadFactory("SessionPoolTimer"));
        this.idlePool = new FixedAsyncPool<SessionImpl>(this, this.timer, this.minSize, this.maxSize, this.maxSize * 2, options.getKeepAliveTimeMillis(), options.getMaxIdleTimeMillis());
        this.settlersPool = new SettlersPool<SessionImpl>(this, this.idlePool, this.timer, 10, 5000);
    }

    @Override
    public CompletableFuture<SessionImpl> create(long deadlineAfter) {
        return this.tableClient.createSessionImpl((CreateSessionSettings)new CreateSessionSettings().setDeadlineAfter(deadlineAfter), this).thenApply(r -> (SessionImpl)r.expect("cannot create session"));
    }

    @Override
    public CompletableFuture<Void> destroy(SessionImpl s) {
        return s.close().thenAccept(r -> r.expect("cannot close session: " + s.getId()));
    }

    @Override
    public boolean isValid(SessionImpl s) {
        return s.switchState(SessionImpl.State.ACTIVE, SessionImpl.State.IDLE);
    }

    @Override
    public CompletableFuture<Boolean> keepAlive(SessionImpl s) {
        return s.keepAlive().thenApply(r -> {
            if (!r.isSuccess()) {
                return Boolean.FALSE;
            }
            SessionStatus status = (SessionStatus)((Object)((Object)r.expect("cannot keep alive session: " + s.getId())));
            return status == SessionStatus.READY;
        });
    }

    CompletableFuture<SessionImpl> acquire(Duration timeout) {
        return this.idlePool.acquire(timeout).thenApply(s -> {
            s.setState(SessionImpl.State.ACTIVE);
            return s;
        });
    }

    void release(SessionImpl session) {
        if (session.switchState(SessionImpl.State.DISCONNECTED, SessionImpl.State.IDLE)) {
            if (!this.settlersPool.offerIfHaveSpace(session)) {
                logger.log(Level.FINE, "Destroy {0} because settlers pool overflow", session);
                session.close();
            }
        } else {
            this.idlePool.release(session);
        }
    }

    void close() {
        try {
            this.idlePool.close();
            this.settlersPool.close();
        }
        finally {
            this.timer.stop();
        }
    }

    public SessionPoolStats getStats() {
        return new SessionPoolStats(this.minSize, this.maxSize, this.idlePool.getIdleCount(), this.settlersPool.size(), this.idlePool.getAcquiredCount(), this.idlePool.getPendingAcquireCount());
    }
}

