/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.rpc.grpc;

import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.grpc.GrpcRequestSettings;
import com.yandex.ydb.core.grpc.GrpcTransport;
import com.yandex.ydb.core.rpc.OperationTray;
import com.yandex.ydb.core.rpc.RpcTransport;
import com.yandex.ydb.core.rpc.StreamControl;
import com.yandex.ydb.core.rpc.StreamObserver;
import com.yandex.ydb.table.YdbTable;
import com.yandex.ydb.table.rpc.TableRpc;
import com.yandex.ydb.table.v1.TableServiceGrpc;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;

@ParametersAreNonnullByDefault
public final class GrpcTableRpc
implements TableRpc {
    private final GrpcTransport transport;
    private final boolean transportOwned;

    private GrpcTableRpc(GrpcTransport transport, boolean transportOwned) {
        this.transport = transport;
        this.transportOwned = transportOwned;
    }

    @Nullable
    public static GrpcTableRpc useTransport(@WillNotClose RpcTransport transport) {
        if (transport instanceof GrpcTransport) {
            return new GrpcTableRpc((GrpcTransport)transport, false);
        }
        return null;
    }

    @Nullable
    public static GrpcTableRpc ownTransport(@WillClose RpcTransport transport) {
        if (transport instanceof GrpcTransport) {
            return new GrpcTableRpc((GrpcTransport)transport, true);
        }
        return null;
    }

    @Override
    public CompletableFuture<Result<YdbTable.CreateSessionResponse>> createSession(YdbTable.CreateSessionRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getCreateSessionMethod(), (Object)request, settings);
    }

    @Override
    public CompletableFuture<Result<YdbTable.DeleteSessionResponse>> deleteSession(YdbTable.DeleteSessionRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getDeleteSessionMethod(), (Object)request, settings);
    }

    @Override
    public CompletableFuture<Result<YdbTable.KeepAliveResponse>> keepAlive(YdbTable.KeepAliveRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getKeepAliveMethod(), (Object)request, settings);
    }

    @Override
    public CompletableFuture<Result<YdbTable.CreateTableResponse>> createTable(YdbTable.CreateTableRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getCreateTableMethod(), (Object)request, settings);
    }

    @Override
    public CompletableFuture<Result<YdbTable.DropTableResponse>> dropTable(YdbTable.DropTableRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getDropTableMethod(), (Object)request, settings);
    }

    @Override
    public CompletableFuture<Result<YdbTable.AlterTableResponse>> alterTable(YdbTable.AlterTableRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getAlterTableMethod(), (Object)request, settings);
    }

    @Override
    public CompletableFuture<Result<YdbTable.CopyTableResponse>> copyTable(YdbTable.CopyTableRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getCopyTableMethod(), (Object)request, settings);
    }

    @Override
    public CompletableFuture<Result<YdbTable.DescribeTableResponse>> describeTable(YdbTable.DescribeTableRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getDescribeTableMethod(), (Object)request, settings);
    }

    @Override
    public CompletableFuture<Result<YdbTable.ExplainDataQueryResponse>> explainDataQuery(YdbTable.ExplainDataQueryRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getExplainDataQueryMethod(), (Object)request, settings);
    }

    @Override
    public CompletableFuture<Result<YdbTable.PrepareDataQueryResponse>> prepareDataQuery(YdbTable.PrepareDataQueryRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getPrepareDataQueryMethod(), (Object)request, settings);
    }

    @Override
    public CompletableFuture<Result<YdbTable.ExecuteDataQueryResponse>> executeDataQuery(YdbTable.ExecuteDataQueryRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getExecuteDataQueryMethod(), (Object)request, settings);
    }

    @Override
    public CompletableFuture<Result<YdbTable.ExecuteSchemeQueryResponse>> executeSchemeQuery(YdbTable.ExecuteSchemeQueryRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getExecuteSchemeQueryMethod(), (Object)request, settings);
    }

    @Override
    public CompletableFuture<Result<YdbTable.BeginTransactionResponse>> beginTransaction(YdbTable.BeginTransactionRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getBeginTransactionMethod(), (Object)request, settings);
    }

    @Override
    public CompletableFuture<Result<YdbTable.CommitTransactionResponse>> commitTransaction(YdbTable.CommitTransactionRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getCommitTransactionMethod(), (Object)request, settings);
    }

    @Override
    public CompletableFuture<Result<YdbTable.RollbackTransactionResponse>> rollbackTransaction(YdbTable.RollbackTransactionRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getRollbackTransactionMethod(), (Object)request, settings);
    }

    @Override
    public StreamControl streamReadTable(YdbTable.ReadTableRequest request, StreamObserver<YdbTable.ReadTableResponse> observer, GrpcRequestSettings settings) {
        return this.transport.serverStreamCall(TableServiceGrpc.getStreamReadTableMethod(), (Object)request, observer, settings);
    }

    @Override
    public StreamControl streamExecuteScanQuery(YdbTable.ExecuteScanQueryRequest request, StreamObserver<YdbTable.ExecuteScanQueryPartialResponse> observer, GrpcRequestSettings settings) {
        return this.transport.serverStreamCall(TableServiceGrpc.getStreamExecuteScanQueryMethod(), (Object)request, observer, settings);
    }

    @Override
    public CompletableFuture<Result<YdbTable.BulkUpsertResponse>> bulkUpsert(YdbTable.BulkUpsertRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getBulkUpsertMethod(), (Object)request, settings);
    }

    public String getDatabase() {
        return this.transport.getDatabase();
    }

    @Nullable
    public String getEndpointByNodeId(int nodeId) {
        return this.transport.getEndpointByNodeId(nodeId);
    }

    public OperationTray getOperationTray() {
        return this.transport.getOperationTray();
    }

    public void close() {
        if (this.transportOwned) {
            this.transport.close();
        }
    }
}

