/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.description;

import com.google.common.collect.ImmutableList;
import com.yandex.ydb.table.description.TableColumn;
import com.yandex.ydb.table.description.TableIndex;
import com.yandex.ydb.table.values.OptionalType;
import com.yandex.ydb.table.values.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TableDescription {
    private final List<String> primaryKeys;
    private final List<TableColumn> columns;
    private final List<TableIndex> indexes;

    private TableDescription(List<String> primaryKeys, List<TableColumn> columns, List<TableIndex> indexes) {
        this.primaryKeys = primaryKeys;
        this.columns = columns;
        this.indexes = indexes;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public List<TableColumn> getColumns() {
        return this.columns;
    }

    public List<TableIndex> getIndexes() {
        return this.indexes;
    }

    public static class Builder {
        private List<String> primaryKeys = Collections.emptyList();
        private LinkedHashMap<String, Type> columns = new LinkedHashMap();
        private List<TableIndex> indexes = Collections.emptyList();

        public Builder addNonnullColumn(String name, Type type) {
            this.columns.put(name, type);
            return this;
        }

        public Builder addNullableColumn(String name, Type type) {
            this.columns.put(name, OptionalType.of(type));
            return this;
        }

        public Builder setPrimaryKey(String name) {
            this.checkColumnKnown(name);
            this.primaryKeys = ImmutableList.of((Object)name);
            return this;
        }

        public Builder setPrimaryKeys(String ... names) {
            if (names.length == 1) {
                return this.setPrimaryKey(names[0]);
            }
            HashSet<String> primaryKeys = new HashSet<String>(names.length);
            for (String name : names) {
                this.checkColumnKnown(name);
                if (primaryKeys.add(name)) continue;
                throw new IllegalArgumentException("non unique primary column name: " + name);
            }
            this.primaryKeys = ImmutableList.copyOf((Object[])names);
            return this;
        }

        public Builder setPrimaryKeys(List<String> names) {
            if (names.size() == 1) {
                return this.setPrimaryKey(names.get(0));
            }
            HashSet<String> primaryKeys = new HashSet<String>(names.size());
            for (String name : names) {
                this.checkColumnKnown(name);
                if (primaryKeys.add(name)) continue;
                throw new IllegalArgumentException("non unique primary column name: " + name);
            }
            this.primaryKeys = ImmutableList.copyOf(names);
            return this;
        }

        public Builder addGlobalIndex(String name, List<String> columns) {
            if (this.indexes.isEmpty()) {
                this.indexes = new ArrayList<TableIndex>(1);
            }
            this.indexes.add(new TableIndex(name, columns, TableIndex.Type.GLOBAL));
            return this;
        }

        public TableDescription build() {
            if (this.columns.isEmpty()) {
                throw new IllegalStateException("cannot build table description with no columns");
            }
            int i = 0;
            Object[] columns = new TableColumn[this.columns.size()];
            for (Map.Entry<String, Type> e : this.columns.entrySet()) {
                columns[i++] = new TableColumn(e.getKey(), e.getValue());
            }
            return new TableDescription(this.primaryKeys, (List)ImmutableList.copyOf((Object[])columns), (List)ImmutableList.copyOf(this.indexes));
        }

        private void checkColumnKnown(String name) {
            if (!this.columns.containsKey(name)) {
                throw new IllegalArgumentException("unknown column name: " + name);
            }
        }
    }
}

