/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.impl;

import java.util.concurrent.TimeUnit;

final class SessionPoolOptions {
    static final SessionPoolOptions DEFAULT = new SessionPoolOptions(10, 50, TimeUnit.MINUTES.toMillis(5L), TimeUnit.MINUTES.toMillis(1L), 5);
    private final int minSize;
    private final int maxSize;
    private final long keepAliveTimeMillis;
    private final long maxIdleTimeMillis;
    private final int creationMaxRetries;

    SessionPoolOptions(int minSize, int maxSize, long keepAliveTimeMillis, long maxIdleTimeMillis, int creationMaxRetries) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.keepAliveTimeMillis = keepAliveTimeMillis;
        this.maxIdleTimeMillis = maxIdleTimeMillis;
        this.creationMaxRetries = creationMaxRetries;
    }

    int getMinSize() {
        return this.minSize;
    }

    int getMaxSize() {
        return this.maxSize;
    }

    long getKeepAliveTimeMillis() {
        return this.keepAliveTimeMillis;
    }

    long getMaxIdleTimeMillis() {
        return this.maxIdleTimeMillis;
    }

    int getCreationMaxRetries() {
        return this.creationMaxRetries;
    }

    SessionPoolOptions withSize(int minSize, int maxSize) {
        return new SessionPoolOptions(minSize, maxSize, this.keepAliveTimeMillis, this.maxIdleTimeMillis, this.creationMaxRetries);
    }

    SessionPoolOptions withKeepAliveTimeMillis(long timeMillis) {
        return new SessionPoolOptions(this.minSize, this.maxSize, timeMillis, this.maxIdleTimeMillis, this.creationMaxRetries);
    }

    SessionPoolOptions withMaxIdleTimeMillis(long timeMillis) {
        return new SessionPoolOptions(this.minSize, this.maxSize, this.keepAliveTimeMillis, timeMillis, this.creationMaxRetries);
    }

    SessionPoolOptions withCreationMaxRetries(int maxRetries) {
        return new SessionPoolOptions(this.minSize, this.maxSize, this.keepAliveTimeMillis, this.maxIdleTimeMillis, maxRetries);
    }
}

