/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.result.impl;

import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.result.ValueReader;
import com.yandex.ydb.table.result.impl.AbstractValueReader;

final class ProtoDictValueReader
extends AbstractValueReader {
    private final ValueProtos.Type type;
    private final AbstractValueReader keyReader;
    private final AbstractValueReader valueReader;
    private ValueProtos.Value value;

    ProtoDictValueReader(ValueProtos.Type type, AbstractValueReader keyReader, AbstractValueReader valueReader) {
        this.type = type;
        this.keyReader = keyReader;
        this.valueReader = valueReader;
    }

    @Override
    protected ValueProtos.Type getType() {
        return this.type;
    }

    @Override
    protected void setValue(ValueProtos.Value value) {
        this.value = value;
    }

    @Override
    public int getDictItemsCount() {
        return this.value.getPairsCount();
    }

    @Override
    public ValueReader getDictKey(int index) {
        ValueProtos.ValuePair pair = this.value.getPairs(index);
        this.keyReader.setValue(pair.getKey());
        return this.keyReader;
    }

    @Override
    public ValueReader getDictValue(int index) {
        ValueProtos.ValuePair pair = this.value.getPairs(index);
        this.valueReader.setValue(pair.getPayload());
        return this.valueReader;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("Dict[");
        for (int i = 0; i < this.getDictItemsCount(); ++i) {
            this.getDictKey(i).toString(sb);
            sb.append(": ");
            this.getDictValue(i).toString(sb);
            sb.append(", ");
        }
        if (this.getDictItemsCount() > 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
    }
}

