/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.rpc.grpc;

import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.grpc.GrpcTransport;
import com.yandex.ydb.core.rpc.OperationTray;
import com.yandex.ydb.core.rpc.RpcTransport;
import com.yandex.ydb.core.rpc.StreamObserver;
import com.yandex.ydb.table.YdbTable;
import com.yandex.ydb.table.rpc.TableRpc;
import com.yandex.ydb.table.v1.TableServiceGrpc;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;

@ParametersAreNonnullByDefault
public final class GrpcTableRpc
implements TableRpc {
    private final GrpcTransport transport;
    private final boolean transportOwned;

    private GrpcTableRpc(GrpcTransport transport, boolean transportOwned) {
        this.transport = transport;
        this.transportOwned = transportOwned;
    }

    @Nullable
    public static GrpcTableRpc useTransport(@WillNotClose RpcTransport transport) {
        if (transport instanceof GrpcTransport) {
            return new GrpcTableRpc((GrpcTransport)transport, false);
        }
        return null;
    }

    @Nullable
    public static GrpcTableRpc ownTransport(@WillClose RpcTransport transport) {
        if (transport instanceof GrpcTransport) {
            return new GrpcTableRpc((GrpcTransport)transport, true);
        }
        return null;
    }

    @Override
    public CompletableFuture<Result<YdbTable.CreateSessionResponse>> createSession(YdbTable.CreateSessionRequest request, long deadlineAfter) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_CREATE_SESSION, (Object)request, deadlineAfter);
    }

    @Override
    public CompletableFuture<Result<YdbTable.DeleteSessionResponse>> deleteSession(YdbTable.DeleteSessionRequest request, long deadlineAfter) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_DELETE_SESSION, (Object)request, deadlineAfter);
    }

    @Override
    public CompletableFuture<Result<YdbTable.KeepAliveResponse>> keepAlive(YdbTable.KeepAliveRequest request, long deadlineAfter) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_KEEP_ALIVE, (Object)request, deadlineAfter);
    }

    @Override
    public CompletableFuture<Result<YdbTable.CreateTableResponse>> createTable(YdbTable.CreateTableRequest request, long deadlineAfter) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_CREATE_TABLE, (Object)request, deadlineAfter);
    }

    @Override
    public CompletableFuture<Result<YdbTable.DropTableResponse>> dropTable(YdbTable.DropTableRequest request, long deadlineAfter) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_DROP_TABLE, (Object)request, deadlineAfter);
    }

    @Override
    public CompletableFuture<Result<YdbTable.AlterTableResponse>> alterTable(YdbTable.AlterTableRequest request, long deadlineAfter) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_ALTER_TABLE, (Object)request, deadlineAfter);
    }

    @Override
    public CompletableFuture<Result<YdbTable.CopyTableResponse>> copyTable(YdbTable.CopyTableRequest request, long deadlineAfter) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_COPY_TABLE, (Object)request, deadlineAfter);
    }

    @Override
    public CompletableFuture<Result<YdbTable.DescribeTableResponse>> describeTable(YdbTable.DescribeTableRequest request, long deadlineAfter) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_DESCRIBE_TABLE, (Object)request, deadlineAfter);
    }

    @Override
    public CompletableFuture<Result<YdbTable.ExplainDataQueryResponse>> explainDataQuery(YdbTable.ExplainDataQueryRequest request, long deadlineAfter) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_EXPLAIN_DATA_QUERY, (Object)request, deadlineAfter);
    }

    @Override
    public CompletableFuture<Result<YdbTable.PrepareDataQueryResponse>> prepareDataQuery(YdbTable.PrepareDataQueryRequest request, long deadlineAfter) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_PREPARE_DATA_QUERY, (Object)request, deadlineAfter);
    }

    @Override
    public CompletableFuture<Result<YdbTable.ExecuteDataQueryResponse>> executeDataQuery(YdbTable.ExecuteDataQueryRequest request, long deadlineAfter) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_EXECUTE_DATA_QUERY, (Object)request, deadlineAfter);
    }

    @Override
    public CompletableFuture<Result<YdbTable.ExecuteSchemeQueryResponse>> executeSchemeQuery(YdbTable.ExecuteSchemeQueryRequest request, long deadlineAfter) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_EXECUTE_SCHEME_QUERY, (Object)request, deadlineAfter);
    }

    @Override
    public CompletableFuture<Result<YdbTable.BeginTransactionResponse>> beginTransaction(YdbTable.BeginTransactionRequest request, long deadlineAfter) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_BEGIN_TRANSACTION, (Object)request, deadlineAfter);
    }

    @Override
    public CompletableFuture<Result<YdbTable.CommitTransactionResponse>> commitTransaction(YdbTable.CommitTransactionRequest request, long deadlineAfter) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_COMMIT_TRANSACTION, (Object)request, deadlineAfter);
    }

    @Override
    public CompletableFuture<Result<YdbTable.RollbackTransactionResponse>> rollbackTransaction(YdbTable.RollbackTransactionRequest request, long deadlineAfter) {
        return this.transport.unaryCall(TableServiceGrpc.METHOD_ROLLBACK_TRANSACTION, (Object)request, deadlineAfter);
    }

    @Override
    public void streamReadTable(YdbTable.ReadTableRequest request, StreamObserver<YdbTable.ReadTableResponse> observer, long deadlineAfter) {
        this.transport.serverStreamCall(TableServiceGrpc.METHOD_STREAM_READ_TABLE, (Object)request, observer, deadlineAfter);
    }

    public OperationTray getOperationTray() {
        return this.transport.getOperationTray();
    }

    public void close() {
        if (this.transportOwned) {
            this.transport.close();
        }
    }
}

