/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.query;

import com.google.common.base.Preconditions;
import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.query.Params;
import com.yandex.ydb.table.values.Type;
import com.yandex.ydb.table.values.Value;
import com.yandex.ydb.table.values.proto.ProtoValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class ParamsMutableMap
implements Params {
    private final HashMap<String, ValueProtos.TypedValue> params;

    ParamsMutableMap() {
        this.params = new HashMap();
    }

    ParamsMutableMap(Map<String, ValueProtos.TypedValue> params) {
        this.params = new HashMap<String, ValueProtos.TypedValue>(params);
    }

    @Override
    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    @Override
    public <T extends Type> Params put(String name, Value<T> value) {
        ValueProtos.TypedValue valuePb = ProtoValue.toTypedValue(value);
        ValueProtos.TypedValue prev = this.params.putIfAbsent(name, valuePb);
        Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"duplicate parameter: %s", (Object)name);
        return this;
    }

    @Override
    public Map<String, ValueProtos.TypedValue> toPb() {
        return Collections.unmodifiableMap(this.params);
    }
}

