/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.query;

import com.google.common.base.Preconditions;
import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.query.Params;
import com.yandex.ydb.table.values.Type;
import com.yandex.ydb.table.values.Value;
import com.yandex.ydb.table.values.proto.ProtoValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class ParamsMutableMap
implements Params {
    private final HashMap<String, Value<?>> params;

    ParamsMutableMap() {
        this.params = new HashMap();
    }

    ParamsMutableMap(Map<String, Value<?>> params) {
        this.params = new HashMap(params);
    }

    @Override
    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    @Override
    public <T extends Type> Params put(String name, Value<T> value) {
        Value<T> prev = this.params.putIfAbsent(name, value);
        Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"duplicate parameter: %s", (Object)name);
        return this;
    }

    @Override
    public Map<String, ValueProtos.TypedValue> toPb() {
        HashMap<String, ValueProtos.TypedValue> result = new HashMap<String, ValueProtos.TypedValue>(this.params.size());
        for (Map.Entry<String, Value<?>> entry : this.params.entrySet()) {
            Value<?> value = entry.getValue();
            String name = entry.getKey();
            ValueProtos.TypedValue valuePb = ProtoValue.toTypedValue(value);
            result.put(name, valuePb);
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public Map<String, Value<?>> values() {
        return Collections.unmodifiableMap(this.params);
    }
}

