/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.values;

import com.yandex.ydb.ValueProtos;
import com.yandex.ydb.table.values.ListValue;
import com.yandex.ydb.table.values.Type;
import com.yandex.ydb.table.values.Value;
import com.yandex.ydb.table.values.proto.ProtoType;
import java.util.List;

public final class ListType
implements Type {
    private final Type itemType;

    private ListType(Type itemType) {
        this.itemType = itemType;
    }

    public static ListType of(Type itemType) {
        return new ListType(itemType);
    }

    public Type getItemType() {
        return this.itemType;
    }

    @Override
    public Type.Kind getKind() {
        return Type.Kind.LIST;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != ListType.class) {
            return false;
        }
        ListType listType = (ListType)o;
        return this.itemType.equals(listType.getItemType());
    }

    @Override
    public int hashCode() {
        return 31 * Type.Kind.LIST.hashCode() + this.itemType.hashCode();
    }

    @Override
    public String toString() {
        return "List<" + this.itemType + '>';
    }

    @Override
    public ValueProtos.Type toPb() {
        return ProtoType.list(this.itemType.toPb());
    }

    public ListValue emptyValue() {
        return new ListValue(this, Value.EMPTY_ARRAY);
    }

    public ListValue newValue(List<Value> items) {
        if (items.isEmpty()) {
            return this.emptyValue();
        }
        return new ListValue(this, items.toArray(Value.EMPTY_ARRAY));
    }

    public ListValue newValueCopy(Value[] items) {
        if (items.length == 0) {
            return this.emptyValue();
        }
        return this.newValueOwn((Value[])items.clone());
    }

    public ListValue newValueOwn(Value ... items) {
        if (items.length == 0) {
            return this.emptyValue();
        }
        return new ListValue(this, items);
    }
}

