/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.ydb.table.impl;

import com.google.common.base.Splitter;
import com.yandex.ydb.core.Result;
import com.yandex.ydb.core.Status;
import com.yandex.ydb.scheme.SchemeOperationProtos;
import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.description.DescribePathResult;
import com.yandex.ydb.table.description.ListDirectoryResult;
import com.yandex.ydb.table.impl.SchemeClientBuilderImpl;
import com.yandex.ydb.table.rpc.SchemeRpc;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;

final class SchemeClientImpl
implements SchemeClient {
    private final SchemeRpc schemeRpc;

    SchemeClientImpl(SchemeClientBuilderImpl builder) {
        this.schemeRpc = builder.schemeRpc;
    }

    @Override
    public CompletableFuture<Status> makeDirectory(String path) {
        return this.mkdir(path);
    }

    @Override
    public CompletableFuture<Status> makeDirectories(String path) {
        if (path.lastIndexOf(47) < 1) {
            return this.mkdir(path);
        }
        String database = this.schemeRpc.getDatabase();
        if (!database.isEmpty() && path.startsWith(database)) {
            path = path.substring(database.length());
        }
        Iterator<String> it = Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)path).iterator();
        CompletableFuture<Status> future = new CompletableFuture<Status>();
        this.mkdirs(database, it, future);
        return future;
    }

    private void mkdirs(String prefix, Iterator<String> it, CompletableFuture<Status> promise) {
        if (!it.hasNext()) {
            promise.complete(Status.SUCCESS);
            return;
        }
        String path = prefix + '/' + it.next();
        this.mkdir(path).whenComplete((s, e) -> {
            if (e != null) {
                promise.completeExceptionally((Throwable)e);
            } else if (!s.isSuccess() && !prefix.isEmpty()) {
                promise.complete((Status)s);
            } else {
                this.mkdirs(path, it, promise);
            }
        });
    }

    private CompletableFuture<Status> mkdir(String path) {
        SchemeOperationProtos.MakeDirectoryRequest request = SchemeOperationProtos.MakeDirectoryRequest.newBuilder().setPath(path).build();
        long deadlineAfter = 0L;
        return this.schemeRpc.makeDirectory(request, 0L).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.schemeRpc.getOperationTray().waitStatus(((SchemeOperationProtos.MakeDirectoryResponse)response.expect("makeDirectory()")).getOperation(), 0L);
        });
    }

    @Override
    public CompletableFuture<Status> removeDirectory(String path) {
        SchemeOperationProtos.RemoveDirectoryRequest request = SchemeOperationProtos.RemoveDirectoryRequest.newBuilder().setPath(path).build();
        long deadlineAfter = 0L;
        return this.schemeRpc.removeDirectory(request, 0L).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.toStatus());
            }
            return this.schemeRpc.getOperationTray().waitStatus(((SchemeOperationProtos.RemoveDirectoryResponse)response.expect("removeDirectory()")).getOperation(), 0L);
        });
    }

    @Override
    public CompletableFuture<Result<DescribePathResult>> describePath(String path) {
        SchemeOperationProtos.DescribePathRequest request = SchemeOperationProtos.DescribePathRequest.newBuilder().setPath(path).build();
        long deadlineAfter = 0L;
        return this.schemeRpc.describePath(request, 0L).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.schemeRpc.getOperationTray().waitResult(((SchemeOperationProtos.DescribePathResponse)response.expect("describePath()")).getOperation(), SchemeOperationProtos.DescribePathResult.class, result -> new DescribePathResult(result.getSelf()), 0L);
        });
    }

    @Override
    public CompletableFuture<Result<ListDirectoryResult>> listDirectory(String path) {
        SchemeOperationProtos.ListDirectoryRequest request = SchemeOperationProtos.ListDirectoryRequest.newBuilder().setPath(path).build();
        long deadlineAfter = 0L;
        return this.schemeRpc.describeDirectory(request, 0L).thenCompose(response -> {
            if (!response.isSuccess()) {
                return CompletableFuture.completedFuture(response.cast());
            }
            return this.schemeRpc.getOperationTray().waitResult(((SchemeOperationProtos.ListDirectoryResponse)response.expect("describeDirectory()")).getOperation(), SchemeOperationProtos.ListDirectoryResult.class, result -> new ListDirectoryResult(result.getSelf(), result.getChildrenList()), 0L);
        });
    }

    @Override
    public void close() {
        this.schemeRpc.close();
    }
}

